#ifndef DBDefsU
#define DBDefsU
//*********************************************************************
// TO USE THIS CODE:
// 1.Include this file in your data module
// 2.Just before the include, add one of the following lines to the data module:
//   define USING_BDE
//   define USING_ADO
//   define USING_INTERB
// 3.Add to the datamodule a TDatabase or TADOConnection or TIBDatabase
// 4.Make sure the names in the data module correspond with names in this file
//*********************************************************************

#ifdef USING_BDE    //________________ BDE Definition________________
  #include <dbtables.hpp>
  #include <dbtables.hpp>
  //Query
  typedef TQuery TFischerQuery;
  #define DB_LINK_PROPERTY DatabaseName
  #define DB_LINK_VALUE    DataModule1->Database1->DatabaseName
  #define DB_PARM_PROPERTY Params
  #define DB_BEGIN_TRANSACTION     DataModule1->Database1->StartTransaction()
  #define DB_COMMIT_TRANSACTION    DataModule1->Database1->Commit()
  #define DB_ROLLBACK_TRANSACTION  DataModule1->Database1->Rollback()

#elif USING_ADO    //________________ ADO Definition________________
  #include <ADOdb.hpp>
  #include <ADOdb.hpp>
  //Query
  typedef TADOQuery TFischerQuery;
  #define DB_LINK_PROPERTY Connection
  #define DB_LINK_VALUE    DataModule1->ADOConnection1
  #define DB_PARM_PROPERTY Parameters
  #define DB_BEGIN_TRANSACTION     DataModule1->ADOConnection1->BeginTrans()
  #define DB_COMMIT_TRANSACTION    DataModule1->ADOConnection1->CommitTrans()
  #define DB_ROLLBACK_TRANSACTION  DataModule1->ADOConnection1->RollbackTrans()

#elif USING_INTERB //_____________ INTERBASE Definition_____________
  #include <Ibquery.hpp>
  #include <Ibquery.hpp>
  //Query
  typedef TIBQuery TFischerQuery;
  #define DB_LINK_PROPERTY Database
  #define DB_LINK_VALUE    DataModule1->IBDatabase1
  #define DB_PARM_PROPERTY Params
  #define DB_BEGIN_TRANSACTION     DataModule1->IBDatabase1->DefaultTransaction->StartTransaction()
  #define DB_COMMIT_TRANSACTION    DataModule1->IBDatabase1->DefaultTransaction->Commit();
  #define DB_ROLLBACK_TRANSACTION  DataModule1->IBDatabase1->DefaultTransaction->Rollback()

#else  #error DBDefsU.h Must define USING_BDE or USING_ADO or USING_INTERB
#endif //end DB check
//----------------------------------------------------------------------#
#endif