
//---------------------------------------------------------------------------
#include <basepch.h>
#pragma hdrstop

#include "StringGridAction.h"
#include "StringGridActionModule.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------

static inline void
  ValidCtrCheck(TStringGridAction*)
{
  new TStringGridAction(NULL);
}
//---------------------------------------------------------------------------

namespace Stringgridaction
{
  void __fastcall PACKAGE Register()
  {
    AnsiString const
      category_name("String grid");
    TComponentClass actions[] = {
      __classid(TStringGridPaste),
      __classid(TStringGridCopy),
      __classid(TStringGridCut)
      };
    int const num_acts = 3;

    RegisterActions(
      category_name, actions, num_acts-1,
      __classid(TSGActionResource)
      );
  }
}
//===========================================================================

bool __fastcall TStringGridAction::
  HandlesTarget(TObject* Target)
{
  return (
    dynamic_cast<TStringGrid*>(Target)
    != NULL
    );
}
//===========================================================================

void __fastcall TStringGridCopy::
  ExecuteTarget(TObject* Target)
{
  TStringGridAction::
    ExecuteTarget(Target);

  // grab a reference to the grid
  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Target);

  // grab the formatted text
  AnsiString const text(
    CellsToText(Grid, Grid.Selection)
    );
  // copy the text to the clipboard
  Clipboard()->AsText = text;
}
//---------------------------------------------------------------------------

void __fastcall TStringGridCopy::
  UpdateTarget(TObject* Target)
{
  TStringGridAction::
    UpdateTarget(Target);
    
  // grab a reference to the grid
  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Target);

  // adjust the Enabled property
  Enabled = Grid.Focused();
}
//---------------------------------------------------------------------------
//===========================================================================

void __fastcall TStringGridCut::
  ExecuteTarget(TObject* Target)
{
  // let the parent class do the copying
  TStringGridCopy::
    ExecuteTarget(Target);

  // grab a reference to the grid
  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Target);

  // prevent grid updates
  Grid.Rows[0]->BeginUpdate();
  try
  {
    // clear the selected cells  
    TGridRect const& Cells =
      Grid.Selection;
    for (int row = Cells.Top;
         row <= Cells.Bottom;
         ++row)
    {
      for (int col = Cells.Left;
           col <= Cells.Right;
           ++col)
      {
        Grid.Cells[col][row] = "";
      }
    }
  }
  __finally
  {
    // restore grid updates
    Grid.Rows[0]->EndUpdate();
  }
}
//===========================================================================

void __fastcall TStringGridPaste::
  ExecuteTarget(TObject* Target)
{
  TStringGridAction::
    ExecuteTarget(Target);

  // grab a reference to the grid
  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Target);

  // extract the text
  AnsiString const text(
    Clipboard()->AsText
    );
  if (!text.IsEmpty())
  {
    // prevent grid updates
    Grid.Rows[0]->BeginUpdate();
    try
    {
      // fill the cells with the text
      TGridCoord const FirstCell =
        Grid.Selection.TopLeft;
      TextToCells(Grid, FirstCell, text);
    }
    __finally
    {
      // restore grid updates
      Grid.Rows[0]->EndUpdate();
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TStringGridPaste::
  UpdateTarget(TObject* Target)
{
  TStringGridAction::
    UpdateTarget(Target);

  // grab a reference to the grid
  TStringGrid& Grid =
    static_cast<TStringGrid&>(*Target);
    
  // adjust the Enabled property
  Enabled = Grid.Focused() &&
    Clipboard()->HasFormat(CF_TEXT);
}
//---------------------------------------------------------------------------

