
//---------------------------------------------------------------------------
#ifndef StringGridActionH
#define StringGridActionH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <Grids.hpp>
#include <ActnList.hpp>
#include <StdActns.hpp>
#include <Clipbrd.hpp>
//---------------------------------------------------------------------------

class PACKAGE TStringGridAction : public TAction
{
public:
  __fastcall TStringGridAction(TComponent* Owner)
    : TAction(Owner) {}

protected:
  virtual bool __fastcall HandlesTarget(
    TObject* Target);
};
//---------------------------------------------------------------------------

class PACKAGE TStringGridCopy
  : public TStringGridAction
{
public:
  __fastcall TStringGridCopy(TComponent* Owner)
    : TStringGridAction(Owner) {}

protected:
  virtual void __fastcall ExecuteTarget(
    TObject* Target);
  virtual void __fastcall UpdateTarget(
    TObject* Target);

protected:
  virtual AnsiString __fastcall CellsToText(
    TStringGrid& Grid, TGridRect const& Cells)
    {
      //
      // compute the total size of the buffer
      // required to hold the text of each selected
      // cell plus the tab and CR/LF delimiters
      //
      int text_len = 0;
      bool const multiple_cells =
        (Cells.Bottom - Cells.Top > 0) ||
        (Cells.Right - Cells.Left > 0);
      for (int row = Cells.Top;
           row <= Cells.Bottom; ++row)
      {
        for (int col = Cells.Left;
             col <= Cells.Right; ++col)
        {
          text_len += Grid.Cells[col][row].Length();
          if (col < Cells.Right)
          {
            ++text_len;
          }
        }
        if (multiple_cells && row <= Cells.Bottom)
        {
          text_len += 2;
        }
      }

      //
      // fill the AnsiString with the text of each
      // cell in a tab- and CR/LF-delimited format
      //
      AnsiString text;
      text.SetLength(text_len);
      text = "";
      for (int row = Cells.Top;
           row <= Cells.Bottom; ++row)
      {
        for (int col = Cells.Left;
             col <= Cells.Right; ++col)
        {
          text += Grid.Cells[col][row];
          if (col < Cells.Right)
          {
            text += '\t';
          }
        }
        if (multiple_cells && row <= Cells.Bottom)
        {
          text += "\r\n";
        }
      }
      return text;
    }
};
//---------------------------------------------------------------------------

class PACKAGE TStringGridCut
  : public TStringGridCopy
{
public:
  __fastcall TStringGridCut(TComponent* Owner)
    : TStringGridCopy(Owner) {}

protected:
  virtual void __fastcall ExecuteTarget(
    TObject* Target);
};
//---------------------------------------------------------------------------

class PACKAGE TStringGridPaste
  : public TStringGridAction
{
public:
  __fastcall TStringGridPaste(TComponent* Owner)
    : TStringGridAction(Owner) {}

protected:
  virtual void __fastcall ExecuteTarget(
    TObject* Target);
  virtual void __fastcall UpdateTarget(
    TObject* Target);

protected:
  virtual void __fastcall TextToCells(
    TStringGrid& Grid, TGridCoord const& FirstCell,
    AnsiString Text)
    {
      // if the text doesn't span multiple
      // cells, copy it as a whole string
      if (Text.Pos("\t") == 0 &&
          Text.Pos("\r\n") == 0)
      {
        Grid.Cells[FirstCell.X][FirstCell.Y] = Text;
        return;
      }

      //
      // parse the text by scanning its contents,
      // character by character, looking for
      // tab and CR delimiters
      //
      int word_start = 1;
      TGridCoord cell = FirstCell;      
      const int text_len = Text.Length();
      for (int index = 1; index < text_len; ++index)
      {
        char const current_char = Text[index];
        // if it's a new column
        if (current_char == '\t')
        {
          Grid.Cells[cell.X++][cell.Y] =
            Text.SubString(
              word_start, index - word_start
              );
          // skip the tab character
          word_start = index + 1;
        }
        // if it's a new row
        else if (current_char == '\r')
        {
          Grid.Cells[cell.X][cell.Y++] =
             Text.SubString(
                word_start, index - word_start
                );
          cell.X = FirstCell.X;
          // skip the CR/LF characters
          word_start = index + 2;
        }
      }
    }
};
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
 