//---------------------------------------------------------------------------
#include <vcl.h>
#include <winbase.h>    //Required for WinAPI Sleep function
#pragma hdrstop

//Remember, even though there is a USEFORM("SplashScreen.cpp", SplashForm);
//Still need to include the header here because we are making direct
//references to the form!
#include "SplashScreen.h"
USERES("BorCon2001Project.res");
USEFORM("ZMemoPadSource.cpp", Form1);
USEFORM("SplashScreen.cpp", SplashForm);
USEFORM("AboutSource.cpp", AboutForm);
USERES("CustomOpenDialog.res");
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR lpCmdLine, int nCmdShow)
{
HANDLE hMutex;
const char hMutexName[] = "OneInstance";

try
  {
  hMutex = OpenMutex(0, false, hMutexName);
  if(hMutex == NULL)
    hMutex = CreateMutex(NULL, true, hMutexName);
  else
    {
    HWND hWnd = FindWindow(0, "ZMemoPad");
    SetForegroundWindow(hWnd);

    if(strlen(lpCmdLine) > 0)
      {
      COPYDATASTRUCT appData;
      appData.cbData = strlen(lpCmdLine);
      appData.lpData = lpCmdLine;
      SendMessage(hWnd, WM_COPYDATA, 0, (LPARAM)&appData);
      }
    return 0;
    }


  Application->Initialize();
  SplashForm = new TSplashForm(NULL);
  SplashForm->Show();
  Application->ProcessMessages();

  Application->CreateForm(__classid(TForm1), &Form1);
  Application->CreateForm(__classid(TAboutForm), &AboutForm);
  Sleep(2000);
  Application->Run();

  ReleaseMutex(hMutex);
  }
catch (Exception &exception)
  {
  Application->ShowException(&exception);
  }
return 0;
}
//---------------------------------------------------------------------------
