//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "SplashScreen.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TSplashForm *SplashForm;
//---------------------------------------------------------------------------
__fastcall TSplashForm::TSplashForm(TComponent* Owner)
    : TForm(Owner)
{
CircleRegion = CreateEllipticRgn(Width / 4, Height / 4, 3*Width/4, 3*Height/4);
FormRegion   = CreateRectRgn(0, 0, Width, Height);
CombineRgn(FormRegion, FormRegion, CircleRegion, RGN_AND);
SetWindowRgn(Handle, FormRegion, true);
}

//---------------------------------------------------------------------------
void __fastcall TSplashForm::FormClose(TObject *Sender, TCloseAction &Action)
{
//Because we call Close, the default is caHide.  We want to free the
//associated memory with the splash screen, so set Action to caFree.
DeleteObject(CircleRegion);
DeleteObject(FormRegion);

Action = caFree;
}

//---------------------------------------------------------------------------
void __fastcall TSplashForm::CreateParams(Controls::TCreateParams &Params)
{
TForm::CreateParams(Params);
Params.Style &= ~WS_CAPTION;
}

//---------------------------------------------------------------------------
void __fastcall TSplashForm::Timer1Timer(TObject *Sender)
{
//Have the Splash Screen take care of its destruction.
SplashForm->Close();
}
//---------------------------------------------------------------------------
