//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "ZMemoPadSource.h"
#include "AboutSource.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

//---------------------------------------------------------------------------
//Implementation of TMyCustomOpenDialog
//---------------------------------------------------------------------------
__fastcall TMyCustomOpenDialog::TMyCustomOpenDialog(TComponent *Owner)
                             : TOpenDialog(Owner)
{
Template = "CUSTOM_ZMP_OPEN";
FConvert = false;
FConvertEnabled = true;
Filter = "MemoPad files (*.zmp)|*.ZMP|Text files (*.txt)|*.TXT|All files (*.*)|*.*";
}
//---------------------------------------------------------------------------
void __fastcall TMyCustomOpenDialog::WndProc(TMessage &Message)
{
switch(Message.Msg)
  {
  //Remember, these commands are sent to the window.
  //Code for when the user clicks on the Checkbox, "convert to zmp file"
  case WM_COMMAND:
    if((LOWORD(Message.WParam) == 101) && (HIWORD(Message.WParam) == BN_CLICKED))
      {
      if(IsDlgButtonChecked(Handle, 101))
        FConvert = true;
      else
        FConvert = false;
      }
  break;

  //Code for when the user changes the selection in the listbox.
  case WM_NOTIFY:
    LPNMHDR note = (LPNMHDR) Message.LParam;
        if (note && (note->code == CDN_SELCHANGE))
      {
      char *fileName = new char[130];

      //Get the Filename that has been selected
      int rtn = CommDlg_OpenSave_GetSpec(note->hwndFrom, fileName, 130);
      if(rtn > 0)
        {
        HWND CheckHandle = GetDlgItem(Handle, 101);
        AnsiString Temp = ExtractFileExt(AnsiString(fileName));
        if(Temp == ".zmp")
          {
          EnableWindow(CheckHandle, FALSE);
          FConvertEnabled = false;
          }
        else
          {
          EnableWindow(CheckHandle, TRUE);
          FConvertEnabled = true;
          }
        }
      delete fileName;
      }
  break;
  }
TOpenDialog::WndProc(Message);
}

//---------------------------------------------------------------------------
//Implementation of Main Form
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
//Loading Icons from Resource File

//Code for Copyright Information-------------------------
OldWndProc = Memo1->WindowProc;
Memo1->WindowProc = MyWndProc;
Clipboard()->Clear();

//Code for resetting Application size and position
//& initializing the recent files list.------------------
FFileName = "";

Reg = new TRegistry;
Reg->RootKey = HKEY_CURRENT_USER;

try
  {
  //Form Settings
  if(Reg->OpenKey("\\SOFTWARE\\ZCircleTechnology\\ZMemoPad\\1.0\\Form", false))
    {
    Left   = Reg->ReadInteger("Left");
    Top    = Reg->ReadInteger("Top");
    Height = Reg->ReadInteger("Height");
    Width  = Reg->ReadInteger("Width");
    Reg->CloseKey();
    }

  //Dynamic Menu Settings
  menucount = 1;
  if(Reg->OpenKey("\\SOFTWARE\\ZCircleTechnology\\ZMemoPad\\1.0\\Menu", false))
    {
    //Use the ReOpen Menu for C++Builder style ReOpen.
    //ReOpen = new TMenuItem(this);
    //ReOpen->Caption = "ReOpen...";
    //File1->Insert(3 + menucount, ReOpen);

    do
      {
      FFileName = Reg->ReadString("Menu" + AnsiString(menucount));
      if(FFileName == "")
        break;
      DynamicMenuItem = new TMenuItem(this);
      DynamicMenuItem->Caption = FFileName;
      DynamicMenuItem->OnClick = DynamicMenuItemClick;
      //Use this code here for Word type, recent Files.
      //Added to the File Menu.
      File1->Insert(3 + menucount, DynamicMenuItem);
      //ReOpen->Add(DynamicMenuItem);
      menucount++;
      MenuList.push_back(FFileName);
      }
    while(true);
    }
    
  if(menucount == 1)
    delete N1;

  //File Association Settings -----------
  Reg->RootKey = HKEY_CLASSES_ROOT;
  if (!Reg->KeyExists(".zmp"))
    CreateFileAssociation();

  if(ParamCount() == 1)
    Memo1->Lines->LoadFromFile(ParamStr(1));
  }
catch(...)
  { }
Reg->CloseKey();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::About1Click(TObject *Sender)
{
AboutForm->Show();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::MyWndProc(TMessage &Message)
{
//Use Alt + 0169 for the Copyright symbol, as seen in AnsiString CR.
std::auto_ptr<TStringList> tp(new TStringList);
AnsiString CR = AnsiString((char)169);
AnsiString CopyNotice("\r\n" + CR + " Copyright ZCircleTechnology");
if(Message.Msg == WM_COPY)
  {
  tp->Add(Memo1->SelText);
  tp->Add(CopyNotice);
  Clipboard()->SetTextBuf((tp)->GetText());
  }
else
  OldWndProc(Message);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::CreateFileAssociation()
{
//Create the registry keys
try
  {
  Reg->RootKey = HKEY_CLASSES_ROOT;
  //create the file extension key.
  Reg->OpenKey(".zmp", true);
  Reg->WriteString("", "ZMemoPad");

  //Create the file association key and its open, and defaultIcon keys.
  Reg->OpenKey("\\ZMemoPad\\shell\\open\\command", true);
  Reg->WriteString("", ParamStr(0) + " %1");
  Reg->OpenKey("\\ZMemoPad\\DefaultIcon", true);
  Reg->WriteString("", ParamStr(0) + AnsiString(",1"));
  }
catch(...)
  {}
}

//---------------------------------------------------------------------------
void __fastcall TForm1::CopyAndOpen(TMessage &Msg)
{
PCOPYDATASTRUCT data = (PCOPYDATASTRUCT)Msg.LParam;
AnsiString S = reinterpret_cast<char *>(data->lpData);

Memo1->Lines->LoadFromFile(S);
FFileName = S;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Open1Click(TObject *Sender)
{
TMyCustomOpenDialog *MyOpenDialog = new TMyCustomOpenDialog(this);
if(MyOpenDialog->Execute())
  {
  if(MyOpenDialog->Convert == true && MyOpenDialog->ConvertEnabled == true)
    ShowMessage("Convert the file"); //Conversion routine
  FFileName = MyOpenDialog->FileName;
  Memo1->Lines->LoadFromFile(FFileName);
  }
delete MyOpenDialog;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Save1Click(TObject *Sender)
{
if(FFileName == "")
  SaveAs1Click(Sender);
else
  Memo1->Lines->SaveToFile(FFileName);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::SaveAs1Click(TObject *Sender)
{
SaveDialog1->Filter = "MemoPad files (*.zmp)|*.ZMP|Text files (*.txt)|*.TXT|All files (*.*)|*.*";
if(!SaveDialog1->Execute())
  return;

FFileName = SaveDialog1->FileName;
Memo1->Lines->SaveToFile(FFileName);

if(menucount > 4)    //Only have 4 items in the recent files history...
  MenuList.pop_back();

MenuList.push_front(FFileName);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
Close();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::DynamicMenuItemClick(TObject *Sender)
{
TMenuItem *Item = dynamic_cast<TMenuItem*>(Sender);
FFileName = Item->Caption;

Memo1->Lines->LoadFromFile(FFileName);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
Reg->RootKey = HKEY_CURRENT_USER;

Reg->OpenKey("\\SOFTWARE\\ZCircleTechnology\\ZMemoPad\\1.0\\Form", true);
Reg->WriteInteger("Left", Left);
Reg->WriteInteger("Top", Top);
Reg->WriteInteger("Height", Height);
Reg->WriteInteger("Width", Width);

Reg->CloseKey();

Reg->OpenKey("\\SOFTWARE\\ZCircleTechnology\\ZMemoPad\\1.0\\Menu", true);

int temp_counter = 1;
for(_MenuList::iterator i = MenuList.begin(); i != MenuList.end(); ++i)
  {
  Reg->WriteString("Menu" + AnsiString(temp_counter), *i);
  temp_counter++;
  }

if(temp_counter == 1)
  Reg->DeleteKey("\\SOFTWARE\\ZCircleTechnology\\ZMemoPad\\1.0\\Menu");

Reg->CloseKey();

delete Reg;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ClearFileHistory1Click(TObject *Sender)
{
MenuList.clear();
}
//---------------------------------------------------------------------------

