#include <vcl.h>
#pragma hdrstop

#include "Main.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   OSMemo->Lines->Add("Using Windows API -------------------");
   GetOSVersionAPI(OSMemo->Lines);
   OSMemo->Lines->Add("");
   OSMemo->Lines->Add("Using VCL Global Variables ----------");
   GetOSVersionVCL(OSMemo->Lines);
   }

void __fastcall TMainForm::GetOSVersionAPI(TStrings *lines)
   {
   OSVERSIONINFO info;
   ZeroMemory(&info, sizeof(OSVERSIONINFO));
   info.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
   bool success = GetVersionEx(&info);
   if (!success)
      {
      lines->Add("Unable to get OS Version Info");
      return;
      }

   lines->Add("Major Version:  " + String((int)info.dwMajorVersion));
   lines->Add("Minor Version:  " + String((int)info.dwMinorVersion));

   DWORD buildNumber = info.dwBuildNumber;
   if (info.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
      buildNumber = LOWORD(buildNumber);
   lines->Add("Build Number:   " + String((int)buildNumber));

   String platform = "Unknown";
   if (info.dwPlatformId == VER_PLATFORM_WIN32s)
      platform = "Win32s";
   else if (info.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS)
      {
      if ((info.dwMajorVersion > 4) || ((info.dwMajorVersion == 4) && (info.dwMinorVersion > 0)))
         platform = "Windows 98";
      else
         platform = "windows 95";
      }
   else if (info.dwPlatformId == VER_PLATFORM_WIN32_NT)
      platform = "Windows NT";
   lines->Add("Platform:       " + platform);

   String csdVersion = info.szCSDVersion;
   if (csdVersion.IsEmpty() && info.dwPlatformId == VER_PLATFORM_WIN32_NT)
      csdVersion = "No Service Pack Installed";
   lines->Add("CSDVersion:     " + csdVersion);
   }

void __fastcall TMainForm::GetOSVersionVCL(TStrings *lines)
   {
   lines->Add("Major Version:  " + String((int)Win32MajorVersion));
   lines->Add("Minor Version:  " + String((int)Win32MinorVersion));

   int buildNumber = Win32BuildNumber;
   if (Win32Platform == VER_PLATFORM_WIN32_WINDOWS)
      buildNumber = LOWORD(buildNumber);
   lines->Add("Build Number:   " + String(buildNumber));

   String platform = "Unknown";
   if (Win32Platform == VER_PLATFORM_WIN32s)
      platform = "Win32s";
   else if (Win32Platform == VER_PLATFORM_WIN32_WINDOWS)
      {
      if ((Win32MajorVersion > 4) || ((Win32MajorVersion == 4) && (Win32MinorVersion > 0)))
         platform = "Windows 98";
      else
         platform = "windows 95";
      }
   else if (Win32Platform == VER_PLATFORM_WIN32_NT)
      platform = "Windows NT";
   lines->Add("Platform:       " + platform);

   if (Win32CSDVersion.IsEmpty() && Win32Platform == VER_PLATFORM_WIN32_NT)
      lines->Add("CSDVersion:     No Service Pack Installed");
   else
      lines->Add("CSDVersion:     " + Win32CSDVersion);
   }

void __fastcall TMainForm::OKBtnClick(TObject *Sender)
   {
   Close();
   }


