#include <vcl.h>
#pragma hdrstop
#include <registry.hpp>
#include "MainU.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TMainForm *MainForm;

__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
  // Get the location of the Images\Buttons directory
  TRegistry* reg = new TRegistry;
  reg->RootKey = HKEY_LOCAL_MACHINE;
  bool res = reg->OpenKey("SOFTWARE\\Borland\\Borland Shared\\Image Files", false);
  if (!res) {
    ShowMessage("Registry key not found");
    delete reg;
    return;
  }
  String imageDir = reg->ReadString("RootDir") + "\\buttons";
  String fileSpec = imageDir + "\\*.bmp";
  delete reg;
  // Find the files in the Images\Buttons directory.
  WIN32_FIND_DATA fd;
  HANDLE h = FindFirstFile(fileSpec.c_str(), &fd);
  if (h == INVALID_HANDLE_VALUE) {
    ShowMessage("No files found");
    return;
  }
  String S = String(fd.cFileName)
    + "=" + imageDir + "\\" + String(fd.cFileName);
  ListBox1->Items->Add(S);
  ComboBox1->Items->Add(S);
  bool done = false;
  do {
    bool res = FindNextFile(h, &fd);
    if (res) {
      // Build a string using the TStringList NAME=VALUE mechanism
      S = String(fd.cFileName)
        + "=" + imageDir + "\\" + String(fd.cFileName);
      ListBox1->Items->Add(S);
      ComboBox1->Items->Add(S);
    }
    done = !res;
  } while (!done);
  // Close the find handle.
  FindClose(h);
  // Fill the variable-height list box with values
  ListBox2->Items->Add("Height: 20");
  ListBox2->Items->Add("Height: 40");
  ListBox2->Items->Add("Height: 15");
  ListBox2->Items->Add("Height: 30");
  ListBox2->Items->Add("Height: 25");
}

void __fastcall TMainForm::ListBox1DrawItem(TWinControl *Control, int Index,
      TRect &Rect, TOwnerDrawState State)
{
  // Get the name of the file. This will be used in the list box display.
  String name = ListBox1->Items->Names[Index];
  // Get the actual filename from the Values property. We'll use this
  // filename to load the bitmap for display.
  String filename = ListBox1->Items->Values[name];

  TColor backColor;
  TColor textColor;

  // Set up the colors used to draw the background and the text.
  // If the item is selected then use the Windows selection colors.
  if (State.Contains(odSelected)) {
    backColor = (TColor)GetSysColor(COLOR_HIGHLIGHT);
    textColor = (TColor)GetSysColor(COLOR_HIGHLIGHTTEXT);
  }
  // Item not selected so use the regular Windows colors.
  else {
    backColor = (TColor)GetSysColor(COLOR_WINDOW);
    textColor = (TColor)GetSysColor(COLOR_WINDOWTEXT);
  }
  // Bold the odd-numbered items just to illustrate.
  if (Index % 2 == 1)
    ListBox1->Canvas->Font->Style = TFontStyles() << fsBold;
  else
    ListBox1->Canvas->Font->Style = TFontStyles();

  // Fill the drawing rect with the background color.
  ListBox1->Canvas->Brush->Color = backColor;
  ListBox1->Canvas->FillRect(Rect);

  // Get the image.
  Graphics::TBitmap* bm = new Graphics::TBitmap;
  bm->LoadFromFile(filename);

  // The button images are actually 16x32 pixels. However, we
  // only want to show the first part of the image (16x16) so
  // we'll modify the source rectangle accordingly.
  TRect src;
  src.Left = 0;
  src.Top = 0;
  src.Right = bm->Height;
  src.Bottom = bm->Height;

  // Set up the destination rectangle.
  TRect dst;
  dst.Left = 5;
  dst.Top = Rect.Top + 1;
  dst.Right = dst.Left + bm->Height;
  dst.Bottom = Rect.Top + bm->Height;

  // Draw the image using BrushCopy(). We use BrushCopy() because
  // it allows us to copy part of an image, with transparency.
  ListBox1->Canvas->BrushCopy(dst, bm, src, bm->TransparentColor);

  // Done with the bitmap so delete it.
  delete bm;

  // Set the color used to draw the text.
  ListBox1->Canvas->Pen->Color = textColor;

  // We'll draw the text 5 pixels to the right of the image so
  // adjust the drawing rectangle's Left by the width of the
  // bitmap plus 5 pixels.
  Rect.Left = dst.Right + 5;

  // Draw the text. We use DrawText so we can vertically
  // center the text in the listbox item.
  DrawText(ListBox1->Canvas->Handle,
    name.c_str(), -1, (RECT*)&Rect, DT_SINGLELINE | DT_VCENTER);
  return;
}

void __fastcall TMainForm::ComboBox1DrawItem(TWinControl *Control,
      int Index, TRect &Rect, TOwnerDrawState State)
{
  // This code is identical to the code that draws the
  // list box so it's not commented.
  String name = ComboBox1->Items->Names[Index];
  String filename = ComboBox1->Items->Values[name];
  TColor backColor;
  TColor textColor;
  if (State.Contains(odSelected)) {
    backColor = (TColor)GetSysColor(COLOR_HIGHLIGHT);
    textColor = (TColor)GetSysColor(COLOR_HIGHLIGHTTEXT);
  }
  else {
    backColor = (TColor)GetSysColor(COLOR_WINDOW);
    textColor = (TColor)GetSysColor(COLOR_WINDOWTEXT);
  }
  if (Index % 2 == 1)
    ComboBox1->Canvas->Font->Style = TFontStyles() << fsBold;
  else
    ComboBox1->Canvas->Font->Style = TFontStyles();
  ComboBox1->Canvas->Brush->Color = backColor;
  ComboBox1->Canvas->FillRect(Rect);
  Graphics::TBitmap* bm = new Graphics::TBitmap;
  bm->LoadFromFile(filename);
  TRect src;
  src.Left = 0;
  src.Top = 0;
  src.Right = bm->Height;
  src.Bottom = bm->Height;
  TRect dst;
  dst.Left = Rect.Left + 2;
  dst.Top = Rect.Top + 1;
  dst.Right = dst.Left + bm->Height;
  dst.Bottom = Rect.Top + bm->Height;
  ComboBox1->Canvas->BrushCopy(dst, bm, src, bm->TransparentColor);
  Rect.Left = bm->Height;
  delete bm;
  ComboBox1->Canvas->Pen->Color = textColor;
  Rect.Left = dst.Right + 5;
  DrawText(ComboBox1->Canvas->Handle,
    name.c_str(), -1, (RECT*)&Rect, DT_SINGLELINE | DT_VCENTER);
  return;
}

void __fastcall TMainForm::ListBox2MeasureItem(TWinControl *Control,
      int Index, int &Height)
{
  // Tell Windows how high each item should be.
  switch (Index) {
    case 0 : Height = 20; break;
    case 1 : Height = 40; break;
    case 2 : Height = 15; break;
    case 3 : Height = 30; break;
    case 4 : Height = 25; break;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::ListBox2DrawItem(TWinControl *Control,
      int Index, TRect &Rect, TOwnerDrawState State)
{
  TColor backColor;
  TColor textColor;
  if (State.Contains(odSelected)) {
    backColor = (TColor)GetSysColor(COLOR_HIGHLIGHT);
    textColor = (TColor)GetSysColor(COLOR_HIGHLIGHTTEXT);
  }
  else {
    backColor = (TColor)GetSysColor(COLOR_WINDOW);
    textColor = (TColor)GetSysColor(COLOR_WINDOWTEXT);
  }
  // Fill the drawing rect with the background color.
  ListBox2->Canvas->Brush->Color = backColor;
  ListBox2->Canvas->FillRect(Rect);
  ListBox2->Canvas->Pen->Color = textColor;
  DrawText(ListBox2->Canvas->Handle,
    ListBox2->Items->Strings[Index].c_str(),
    -1, (RECT*)&Rect, DT_SINGLELINE | DT_VCENTER);
  return;
}
//---------------------------------------------------------------------------


