#ifndef FFDataH
#define FFDataH


/* File Attributes ---------------------------------------------------------------------------------

#define FILE_ATTRIBUTE_READONLY             0x00000001
#define FILE_ATTRIBUTE_HIDDEN               0x00000002
#define FILE_ATTRIBUTE_SYSTEM               0x00000004
#define FILE_ATTRIBUTE_DIRECTORY            0x00000010
#define FILE_ATTRIBUTE_ARCHIVE              0x00000020
#define FILE_ATTRIBUTE_DEVICE               0x00000040
#define FILE_ATTRIBUTE_NORMAL               0x00000080
#define FILE_ATTRIBUTE_TEMPORARY            0x00000100
#define FILE_ATTRIBUTE_SPARSE_FILE          0x00000200
#define FILE_ATTRIBUTE_REPARSE_POINT        0x00000400
#define FILE_ATTRIBUTE_COMPRESSED           0x00000800
#define FILE_ATTRIBUTE_OFFLINE              0x00001000
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000
#define FILE_ATTRIBUTE_ENCRYPTED            0x00004000

------------------------------------------------------------------------------------------------- */

class TFFData
   {
   public:
      TFFData();

      String GetName();
      String GetAlternateName();

      unsigned long GetAttributes();
      bool HasAttribute(DWORD attribute);
      bool IsFolder();
      bool IsFile();

      __int64 GetSize();

      bool GetCreationDateTime(TDateTime &dateTime);
      bool GetLastAccessDateTime(TDateTime &dateTime);
      bool GetLastWriteDateTime(TDateTime &dateTime);

      WIN32_FIND_DATA GetRawData();

   private:
      bool FileTimeToDateTime(const FILETIME fileTime, TDateTime &dateTime);

      WIN32_FIND_DATA data;

   friend class TFindFile;
   };


// Inline Functions --------------------------------------------------------------------------------

inline TFFData::TFFData()
   {
   ZeroMemory(&data, sizeof(data));
   }

inline String TFFData::GetName()
   {
   return(String(data.cFileName));
   }

inline String TFFData::GetAlternateName()
   {
   return(String(data.cAlternateFileName));
   }

inline unsigned long TFFData::GetAttributes()
   {
   return(data.dwFileAttributes);
   }

inline bool TFFData::HasAttribute(unsigned long attribute)
   {
   return(data.dwFileAttributes & attribute ? true : false);
   }

inline bool TFFData::IsFolder()
   {
   return(HasAttribute(FILE_ATTRIBUTE_DIRECTORY));
   }

inline bool TFFData::IsFile()
   {
   return(!IsFolder());
   }

inline __int64 TFFData::GetSize()
   {
   return(data.nFileSizeHigh * MAXDWORD + data.nFileSizeLow);
   }

inline bool TFFData::GetCreationDateTime(TDateTime &dateTime)
   {
   return(FileTimeToDateTime(data.ftCreationTime, dateTime));
   }

inline bool TFFData::GetLastAccessDateTime(TDateTime &dateTime)
   {
   return(FileTimeToDateTime(data.ftLastAccessTime, dateTime));
   }

inline bool TFFData::GetLastWriteDateTime(TDateTime &dateTime)
   {
   return(FileTimeToDateTime(data.ftLastWriteTime, dateTime));
   }


#endif   // FFDataH

