#include <vcl.h>
#pragma hdrstop

#include "FindFile.h"


// -------------------------------------------------------------------------------------------------

class TFFStack
	{
   public:
   	TFFStack();
   	~TFFStack();

      void Push(AnsiString name);
      AnsiString Pop();

      void Empty();

      bool Contains(String name);
      bool IsEmpty();

   private:
      TStringList *list;
   };

inline TFFStack::TFFStack()
   {
   list = new TStringList;
   list->Sorted = true;
   list->Duplicates = dupIgnore;
   }

inline TFFStack::~TFFStack()
   {
   delete list;
   }

inline void TFFStack::Push(AnsiString name)
   {
   list->Add(name);
   }

inline AnsiString TFFStack::Pop()
   {
   AnsiString temp = list->Strings[0];
   list->Delete(0);
   return(temp);
   }

inline void TFFStack::Empty()
   {
   list->Clear();
   }

inline bool TFFStack::Contains(String name)
   {
   int index;
   return(list->Find(name, index));
   }

inline bool TFFStack::IsEmpty()
   {
   return(list->Count == 0);
   }


// -------------------------------------------------------------------------------------------------

void TFindFile::Find(String filePattern)
   {
   stop = false;

   String curDir = ExtractFilePath(ExpandFileName(filePattern));
   String fileName = ExtractFileName(filePattern);

   bool skip = false;
   if (FOnSearchFolder) FOnSearchFolder(this, curDir, skip);
   if (FOnFileFound && skip == false) FindFiles(curDir + fileName);

   if (searchSubfolders)
      {
      TFFStack dirStack;

      while (stop == false)
         {
         Application->ProcessMessages();

         FindDirs(curDir, dirStack);
         if (dirStack.IsEmpty()) break;

         curDir = dirStack.Pop();

         skip = false;
         if (FOnSearchFolder) FOnSearchFolder(this, curDir, skip);
         if (skip) continue;

         if (FOnFileFound) FindFiles(curDir + fileName);
         }
      }

   stop = true;
   }

void TFindFile::FindDirs(String baseDir, TFFStack &stack)
   {
   TFFData ffData;

   String dirPattern = baseDir + "*.*";

   HANDLE handle = FindFirstFile(dirPattern.c_str(), &ffData.data);
   if (handle != INVALID_HANDLE_VALUE)
      {
      bool found = true;

      while (found == true && stop == false)
         {
         Application->ProcessMessages();

         if (ffData.IsFolder() && ffData.GetName() != "." && ffData.GetName() != "..")
            stack.Push(baseDir + ffData.GetName() + "\\");

         found = (FindNextFile(handle, &ffData.data) != 0);
         }

      FindClose(handle);
      }
   }

void TFindFile::FindFiles(String filePattern)
   {
   TFFData ffData;

   HANDLE handle = FindFirstFile(filePattern.c_str(), &ffData.data);
   if (handle != INVALID_HANDLE_VALUE)
      {
      bool found = true;

      while (found == true && stop == false)
         {
         Application->ProcessMessages();

         if (FOnFileFound && ffData.GetName() != "." && ffData.GetName() != "..")
            FOnFileFound(this, ffData.GetName(), ExtractFilePath(filePattern), ffData);
         found = (FindNextFile(handle, &ffData.data) != 0);
         }

      FindClose(handle);
      }
   }


#pragma package(smart_init)

