#ifndef FindFileH
#define FindFileH

#include "FFData.h"

class TFFStack;

typedef void __fastcall (__closure *TFileFound)(TFindFile *Sender, String fileName,
   String foldername, TFFData data);
typedef void __fastcall (__closure *TSearchFolder)(TFindFile *Sender, String folderName,
   bool &skip);

class TFindFile
   {
   public:
      TFindFile();

      void Find(String filePattern);
      void Stop();

      __property bool SearchSubfolders = {read = searchSubfolders, write = searchSubfolders};
      __property TFileFound OnFileFound = {read = FOnFileFound, write = FOnFileFound};
      __property TSearchFolder OnSearchFolder = {read = FOnSearchFolder, write = FOnSearchFolder};

   private:
      void FindFiles(String filePattern);
      void FindDirs(String baseDir, TFFStack &stack);

      TFileFound FOnFileFound;
      TSearchFolder FOnSearchFolder;

      bool stop;
      bool searchSubfolders;
   };

inline TFindFile::TFindFile()
   {
   FOnFileFound = 0;
   FOnSearchFolder = 0;

   stop = true;
   searchSubfolders = false;
   }

inline void TFindFile::Stop()
   {
   stop = true;
   }


#endif   // FindFilesH

