/*
	TheLib.dll - sample code for threading in VB4
*/

// includes
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <commctrl.h>

// globals
static HINSTANCE g_hInstance;



/*-------------------------------------------------------------------*/
// Procedure....: DllMain()
// Description..: Library main function
// Input........: HINSTANCE, DWORD, LPVOID
// Output.......: INT
/*-------------------------------------------------------------------*/
INT APIENTRY DllMain( HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved )
{
	 if (dwReason == DLL_PROCESS_ATTACH)
		  g_hInstance = hInstance;
	 return TRUE;
}




/*-------------------------------------------------------------------*/
// Procedure....: Go()
// Description..: Sample function
// Input........: HWND
// Output.......: INT
/*-------------------------------------------------------------------*/
INT APIENTRY Go( HWND hwndAni )
{
	// local data

	/*
   	This function will be called from within a secondary thread
	*/
	Animate_Open( hwndAni, "Sample.avi" );
	Animate_Play( hwndAni, 0, -1, -1 );
   ExitThread( ERROR_SUCCESS );
	return 1;
}






/*-------------------------------------------------------------------*/
// Procedure....: Quit()
// Description..: Sample function
// Input........: HWND
// Output.......: INT
/*-------------------------------------------------------------------*/
INT APIENTRY Quit( HWND hwndAni )
{
	// local data

	Animate_Stop( hwndAni );
	return 1;
}
