// ThreadCtl.cpp : Implementation of the CThreadCtrl OLE control class.

#include "stdafx.h"
#include "thread.h"
#include "ThreadCtl.h"
#include "ThreadPpg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CThreadCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CThreadCtrl, COleControl)
	//{{AFX_MSG_MAP(CThreadCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CThreadCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CThreadCtrl)
	DISP_PROPERTY_NOTIFY(CThreadCtrl, "Library", m_library, OnLibraryChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CThreadCtrl, "Function", m_function, OnFunctionChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CThreadCtrl, "Params", m_params, OnParamsChanged, VT_I4)
	DISP_FUNCTION(CThreadCtrl, "Create", Create, VT_I4, VTS_NONE)
	DISP_FUNCTION(CThreadCtrl, "Terminate", Terminate, VT_EMPTY, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CThreadCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CThreadCtrl, COleControl)
	//{{AFX_EVENT_MAP(CThreadCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CThreadCtrl, 1)
	PROPPAGEID(CThreadPropPage::guid)
END_PROPPAGEIDS(CThreadCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CThreadCtrl, "THREAD.ThreadCtrl.1",
	0x13d77c87, 0xba46, 0x11cf, 0xba, 0x50, 0x44, 0x45, 0x53, 0x54, 0, 0)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CThreadCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DThread =
		{ 0x13d77c85, 0xba46, 0x11cf, { 0xba, 0x50, 0x44, 0x45, 0x53, 0x54, 0, 0 } };
const IID BASED_CODE IID_DThreadEvents =
		{ 0x13d77c86, 0xba46, 0x11cf, { 0xba, 0x50, 0x44, 0x45, 0x53, 0x54, 0, 0 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwThreadOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CThreadCtrl, IDS_THREAD, _dwThreadOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl::CThreadCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CThreadCtrl

BOOL CThreadCtrl::CThreadCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegApartmentThreading to 0.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_THREAD,
			IDB_THREAD,
			afxRegApartmentThreading,
			_dwThreadOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl::CThreadCtrl - Constructor

CThreadCtrl::CThreadCtrl()
{
	InitializeIIDs(&IID_DThread, &IID_DThreadEvents);

	// TODO: Initialize your control's instance data here.
	m_library = "";
	m_function = "";
	m_params = 0;
}


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl::~CThreadCtrl - Destructor

CThreadCtrl::~CThreadCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl::OnDraw - Drawing function

void CThreadCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
	pdc->Ellipse(rcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl::DoPropExchange - Persistence support

void CThreadCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl::OnResetState - Reset control to default state

void CThreadCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl::AboutBox - Display an "About" box to the user

void CThreadCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_THREAD);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl message handlers

void CThreadCtrl::OnLibraryChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CThreadCtrl::OnFunctionChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CThreadCtrl::OnParamsChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

long CThreadCtrl::Create() 
{
	// local data
	FARPROC pfn;
	DWORD dwThreadId;

	
	// load the library
	m_hModule = LoadLibrary( m_library );
	if( m_hModule==NULL )
	{
		CString s = "Error while loading the library: ";
		MessageBox( s + m_library, NULL, MB_OK );
		return 1;
	}

	// load the function
	pfn = GetProcAddress( m_hModule, m_function );
	if( pfn==NULL )
	{
		CString s = "Error while loading the function: ";
		MessageBox( s + m_function, NULL, MB_OK );
		return 2;
	}
	
	// now try to create the thread
	m_hThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)pfn, (LPVOID)m_params, 0, &dwThreadId );
	if( m_hThread==NULL )
	{
		CString s = "Error while loading the thread: ";
		MessageBox( s, NULL, MB_OK );
		return 3;
	}

	return 0;
}

void CThreadCtrl::Terminate() 
{
	// just free the library
	CloseHandle( m_hThread );
	FreeLibrary( m_hModule );
}
