// ThreadCtl.h : Declaration of the CThreadCtrl OLE control class.

/////////////////////////////////////////////////////////////////////////////
// CThreadCtrl : See ThreadCtl.cpp for implementation.

class CThreadCtrl : public COleControl
{
	DECLARE_DYNCREATE(CThreadCtrl)

// Constructor
public:
	CThreadCtrl();

// Overrides

	// Drawing function
	virtual void OnDraw(
				CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid);

	// Persistence
	virtual void DoPropExchange(CPropExchange* pPX);

	// Reset control state
	virtual void OnResetState();

// Implementation
protected:
	~CThreadCtrl();

	DECLARE_OLECREATE_EX(CThreadCtrl)    // Class factory and guid
	DECLARE_OLETYPELIB(CThreadCtrl)      // GetTypeInfo
	DECLARE_PROPPAGEIDS(CThreadCtrl)     // Property page IDs
	DECLARE_OLECTLTYPE(CThreadCtrl)		// Type name and misc status

// Message maps
	//{{AFX_MSG(CThreadCtrl)
		// NOTE - ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dispatch maps
	//{{AFX_DISPATCH(CThreadCtrl)
	CString m_library;
	afx_msg void OnLibraryChanged();
	CString m_function;
	afx_msg void OnFunctionChanged();
	long m_params;
	afx_msg void OnParamsChanged();
	afx_msg long Create();
	afx_msg void Terminate();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()

	afx_msg void AboutBox();

private:
	HMODULE m_hModule;	// library module handle
	HANDLE m_hThread;	// thread handle

// Event maps
	//{{AFX_EVENT(CThreadCtrl)
	//}}AFX_EVENT
	DECLARE_EVENT_MAP()

// Dispatch and event IDs
public:
	enum {
	//{{AFX_DISP_ID(CThreadCtrl)
	dispidLibrary = 1L,
	dispidFunction = 2L,
	dispidParams = 3L,
	dispidCreate = 4L,
	dispidTerminate = 5L,
	//}}AFX_DISP_ID
	};
};
