// File: SampledImage.C
//
// (c) 1996 Mayur Patel

#include <SampledImage.h>
#include <assert.h>
SampledImage::SampledImage( void )
{
   _pFiller = 0;
   _area.x = 0;
   _area.y = 0;
   _area.z = 1;
   _area.c = 1;   
   _area.width = 0;
   _area.height = 0;
   return;
}

SampledImage::~SampledImage( void )
{
   if ( _pFiller )
      _pFiller->unregisterReference();
   return;
}


void
SampledImage::setArea( const ImageArea& setArea )
{
   _area = setArea;
   return;
}


void
SampledImage::setFillStrategy( FillStrategy *pStrategy )
{
   if ( _pFiller )
      _pFiller->unregisterReference();
   _pFiller = pStrategy;
   if ( _pFiller )
      _pFiller->registerReference();
   return;
}


int
SampledImage::applyFillStrategy( ImageTile *pWriteHere )
{
   int	iRet = 0;
   
   if ( pWriteHere && _pFiller )
      iRet = _pFiller->fillTile( this, pWriteHere );

   return ( iRet );
}

// ************************************************************************

ImageTile *
SampledImage::newTile( const ImageArea& area )
{
   ImageMan *pManager;
   ImageTile *pTile = 0;

   pManager = getManPointer();
   if ( pManager )
      pTile = pManager->newTile( this, area );

   return( pTile );
}
