// File: Type.C
//
// (c) 1996 Mayur Patel
//

#include <Type.h>
unsigned bytesize( Type type )
{
   unsigned uRet;
   
   switch ( type )
   {

#define TYPEMACRO( label, type, low, high, prec, func )  \
       case( label ): uRet=sizeof(type); break;
#include <Type.m>   
   
      default:
         uRet = 0;
         break;
   };
   return ( uRet );
}


unsigned
precedence( Type type )
{
   unsigned uRet;
   
   switch ( type )
   {

#define TYPEMACRO( label, type, low, high, prec, func )  \
      case( label ): uRet=prec; break;
#include <Type.m>   
   
      default:
         uRet = 0;
         break;
   };
   return ( uRet );
}

// *******************************************************************

void
typecast_Real( 
   register unsigned long ulLoop, 
   register float *pDest,
   void *vpSource,
   Type srcType 
   
   )
{
#define TYPEMACRO( label, type, low, high, prec, func )	\
   type 		*  label##srcptr ;
#include <Type.m>   
   float		rFactor;

   switch( srcType ) {
   
#define TYPEMACRO( label, type, low, high, prec, func ) \
case( label ): rFactor = 1.0 / (float) ( high - low ) ; \
               label##srcptr = ( type * ) vpSource;      \
               while ( ulLoop-- ) {			\
               *pDest = ((float) *(label##srcptr++) - low )* rFactor; \
               pDest++; 				\
               } break;				
#include <Type.m>					
   };
   
   return;
}

// -------------------------------------------------------------------

void
typecast_UShort (
   register unsigned long 	ulLoop,
   register unsigned short 	*pDest,
   void 			*vpSource,
   Type 			srcType 
)
{
#define TYPEMACRO( label, type, low, high, prec, func ) \
   type 		*  label##srcptr ;
#include <Type.m>   
   
   switch( srcType ) {
   
#define TYPEMACRO( label, type, low, high, prec, func ) \
case( label ):   label##srcptr = ( type * ) vpSource;   \
                 while ( ulLoop-- ) {			\
                 *pDest = (unsigned short) ((( *(label##srcptr++) \
                            - low ) * 0x0FFFF) / ( high - low )); \
                 pDest++; 				\
                 } break;				
#include <Type.m>					
   };
   
   return;
}

// -------------------------------------------------------------------
void
typecast_UChar (
   register unsigned long	ulLoop,
   register unsigned char 	*pDest,
   void 			*vpSource,
   Type 			srcType 
)
{
#define TYPEMACRO( label, type, low, high, prec, func )	\
   type 		*  label##srcptr ;
#include <Type.m>   
   
   switch( srcType ) {
   
#define TYPEMACRO( label, type, low, high, prec, func )	\
case( label ):   label##srcptr = ( type * ) vpSource;    \
                while ( ulLoop-- ) {			\
                 *pDest = (unsigned char)((((*(label##srcptr++)) \
                            - low ) * 0x0FF ) / ( high - low )); \
                 pDest++; 				\
                 } break;				
#include <Type.m>					
   };
   
   return;
}
