/* AES.h */

#define WIN32_EXTRA_LEAN
#include <windows.h>

#include <time.h>
#include <list>

#define ERR_INSUFFICIENT_MEMORY	-1
#define ERR_CANT_CREATE_HANDLE	-2

class AES
{
private:
	class Event
	{
	private:
		ULONG wakeUpTime;
		void (*func)(void*);
		void *data;

	public:
		Event(ULONG ulDelay, void (*pFunc)(void*), void *pData) : 
			func(pFunc), data(pData) 
			{ wakeUpTime = ULONG(clock() + ulDelay * CLOCKS_PER_SEC); }
		ULONG When(void) { return wakeUpTime; }
		void Work(void) { (*func)(data); }
	};

	typedef list< Event*, allocator< Event* > > EventList;

	class PoolThread
	{
	private:
		BOOL dying;
		HANDLE sem, handle;
		Event *event;

		static unsigned __stdcall Worker(void *ref);

	public:
		PoolThread(int stack = 0);
		~PoolThread(void);

		int InitState;

		BOOL Busy(void) { return event != 0; }
		void Alloc(Event *ev) { event = ev; ReleaseSemaphore(sem, 1, 0); }
	};

	BOOL dying;
	HANDLE sem, handle;
	CRITICAL_SECTION critSec;
	int size;
	PoolThread *pool;
	EventList eventList;

	static unsigned __stdcall Monitor(void *ref);

public:
	AES(int threads = 10);
	virtual ~AES(void);

	int InitState;

	typedef void *AESHandle;

	AESHandle ScheduleEvent(ULONG ulDelay, void (*pFunc)(void*), void *pData);
	BOOL CancelEvent(AESHandle hEvent);
};

