#ifndef COLOR16_H
#define COLOR16_H

struct Rgb24 {
	float r, g, b;
	Rgb24(float fr, float fg, float fb) { r = fr; g = fg; b = fb; }
	Rgb24(float f) { r = f; g = f; b = f; }
	Rgb24() { r = 0; g = 0; b = 0; }
	void Set(struct Rgb24 &p_rgb) { r = p_rgb.r; g = p_rgb.g; b = p_rgb.b; }
	void Scale(float val) { r *= val; g *= val; b *= val; }
};

typedef Rgb24 Rgb;

typedef struct _Rgb16 {
	int a : 1;
	int r : 5;
	int g : 5;
	int b : 5;
} Rgb16;

class PackedRgb {
	Rgb16			packed;
	short			shorty;
public:	
	float			flr, flg, flb;
					PackedRgb();
					PackedRgb(float fr, float fg, float fb);
					PackedRgb(short s);
	void			SetShorty();
	short			GetShorty() { return shorty; }
	void			Set(float fr, float fg, float fb);
};

typedef struct _ColorDef {
	float r, g, b;
} ColorDef;

struct Color {
	static ColorDef red;
	static ColorDef green;
	static ColorDef blue;
	static ColorDef black;
	static ColorDef white;
};

#endif