// MCFile.cpp

#include "MCFile.h"

#if defined(macintosh)
	#include <OSUtils.h>
	#include "HandyStuff.h"
	#ifndef PATH_DELIMITER
		#define PATH_DELIMITER ':'
	#endif
#else
	#ifndef PATH_DELIMITER
		#define PATH_DELIMITER '\\'
	#endif
#endif

#if defined(macintosh)

void inf(char *txt) 
{	
	Str255 pStr;
	CtoP(txt, pStr);
	ParamText( pStr, "\p", "\p", "\p" ); 
	Alert( ALERTID, 0 );
}

int DemoTimedOut(int year, int month, int day)
{
	unsigned long secs, limit;
	DateTimeRec dtr;

	dtr.year = (short)year;
	dtr.month = (short)month;
	dtr.day = (short)day;
	dtr.hour = 0;
	dtr.minute = 0;
	dtr.second = 0;
	dtr.dayOfWeek = 0;

	DateToSeconds(&dtr, &limit);
	ReadDateTime(&secs);
	if (secs >= limit)
	{
		inf("This demo application has expired. Comtact HeadsOff.com for further info.");
		return 1;
	}
	return 0;
}

#else // windows

int DemoTimedOut(int day, int month, int year)
{
	SYSTEMTIME st;
	int expired = 0;

	GetSystemTime(&st);
	
	// check year
	if (st.wYear < year)
		expired = 0;
	else if (st.wYear > year)
		expired = 1;
	else
	{
		// check month
		if (st.wMonth < month)
			expired = 0;
		else if (st.wMonth > month)
			expired = 1;
		else
		{
			// check day
			if (st.wDay < day)
				expired = 0;
			else if (st.wDay >= day)
				expired = 1;
		}
	}
	if (expired)
	{
		MessageBox(NULL, "This demo application has expired. Contact HeadsOff.com for further info", "Time out!", MB_OK);
		return 1;
	}
	else 
		return 0;
}

void inf(char *txt) 
{
	MessageBox(NULL, txt, "Info", MB_OK);
}
#endif
	
short CharToNum( char * str )
{
	int sLen, num, n;
	
	sLen = StrLen( str );
	num = 0;
	
	for ( n = 1; n <= sLen; n++ )
		num += ( str[n - 1]  - '0' ) *  Pow( 10, sLen - n );
	return (short) num;
}

unsigned long CharToULongNum( char * str )
{
	short sLen, n;
	unsigned long num;
	
	sLen = StrLen( str );
	num = 0;
	
	for ( n = 1; n <= sLen; n++ )
		num += ( str[n - 1]  - '0' ) *  Pow( 10, sLen - n );
	return  num;
}

short CompareStr( char* subStr, char * mainStr )
{
	int n, x, subLen;
	char * ptr;
	
	subLen = StrLen( subStr );
	ptr = mainStr;
	
	for (x = 0; x <= ( StrLen( mainStr ) - (subLen - 1)); x ++) {
		for ( n = 0; n < subLen; n++ ) {
			if ( subStr[n] != mainStr[x + n] ) 
				break;
			else
				if (n >= subLen) return x + 1; // found it, return pos ( beginning with 1 )
		}
	}
	return 0;
}

void CopyStr( char to[], const char from[] )
{	
	int n = 0;
	while (( to[n] = from[n] ) != '\0')
		n++;
}

void UpperStr( char *str )
{
	char temp, *hdr;
	hdr = str;
	
	while (( temp = *hdr ) != '\0' ) {
		if ( temp >= 'a' )
			*hdr = temp - ('a' - 'A');
		hdr++;
	}
}

int StripNonDOS(char *cstr)
{
	char sbuff[512];
	short filthy = 0;
	char *temp, *c, ch;
	temp = sbuff, c = cstr;
	while ((ch = *c++) != NULL)
		if (OKDOS(ch))
			*temp++ = ch;
		else filthy++;
	*temp = 0;
	if (filthy)
	{
		strcpy(cstr, sbuff);
		return 1;
	}
	return 0;
}	
	
short StrLen( const char * str )
{	
	short n;
	
	for ( n = 0; *str++; n++ )
		;
	return n;
}

void SubStr(char *c, char *sub, int n)
{
	// note storage of at least n+1 bytes must have been allocated for sub!
	int m, l;
	l = strlen(c);
	if (n > l) // bit silly eh?
		n = l;
	for (m = 0; m < n; m++)
		sub[m] = c[m];
	sub[m] = 0;
} 

void LastInPath(char *fullPath, char *shortStuff)
{
	fullPath += strlen(fullPath) - 1;
	while ((*shortStuff++ = *fullPath--) != PATH_DELIMITER)
		;
	*shortStuff = '\0';
}

void MakeUnique(char *prev, char *thisOne)
{
	int l;
	l = TabbedStrlen(prev, ',');
	if (l < 8)
	{
		// easy! just tack a number on the end
		strcat(thisOne, "0");
		return;
	}
	else
	{
		// a bit more work
		for (l = 7; l >= 0; l--)
		{
			if (isdigit(thisOne[l]))
				// see if we've got an incr to spare
				if (thisOne[l] < '9')
					// we can just add 1
					thisOne[l]++;
				else
					// check the next one back
					continue;
			else
			{
				// not a digit so make it one
				thisOne[l] = '0';
				return;
			}
		}
	}
}

void NumTo3Digits(int num, char *pbuf)
{
	pbuf[0] = '0' + ((int) num /100);
	if (num > 99) num %= 100;
	pbuf[1] = '0' + ((int) num /10);
	if (num > 9) num %= 10;
	pbuf[2] = '0' + num;
		
}

int TabbedStrcmp(char *s1, char *s2, char tab)
{
	int cnt, l, l2;
	l = TabbedStrlen(s1,tab);
	l2 = TabbedStrlen(s2, tab);
	if (l != l2)
		return 1; // not equal
	for (cnt = 0; cnt < l; cnt++)
		if (*s1++ != *s2++)
			return 1;
	return 0; // equiv
}

int TabbedStrlen(char *c, char tab)
{
	int cnt = 0;
	while ((*c != tab && *c != 0) && (cnt++ <= 1024)) // protect from infinite loop
		c++; 
	return cnt;
}

void StrCat(char *dest, char *src)
{
	while (*dest++)
		;
	while ((*dest++ = *src++) != NULL)
		;
}

short CompareStrCaseless( const char* subStr, const char * mainStr ) // case insensitive
{
	int n, x, subLen;
	const char * ptr;
	
	subLen = StrLen( subStr );
	ptr = mainStr;
	
	for (x = 0; x <= ( StrLen( mainStr ) - (subLen - 1)); x ++) {
		for ( n = 0; n < subLen; n++ ) {
			if ( UpperChar(subStr[n]) != UpperChar(mainStr[x + n]) ) 
				return 0;
			else
				if (n >= (subLen - 1)) 
					return x + 1; // found it, return pos ( beginning with 1 )
		}
	}
	return 0;
}

long Pow( long base, short n )
{
	long p;
	
	for ( p = 1; n > 0; --n )
		p *= base;
	return p;
}	 			

int GetRecordLength(void *buff)
{
	// newline is record delimiter
	int i;
	char *cp = (char*) buff;
	for (i = 0; i < 0xFFFF; i++)
		if ((char)*(cp+i) == '\n')
			break;
	return i+1; // include newline char
}
