#include "Raver.h"
#include "AppMain.h"
	
Raver::Raver(int vpwidth, int vpheight, void *data, int vls) 
	: Renderer(vpwidth, vpheight, data, vls),
	drawContext(NULL),
	cache(NULL),
	engine(NULL),
	perspectiveZ(false),
	num_textures(256), // hard coded as only 1 byte texture reference index
	pointGrid(NULL)		
{
	InitTexTable();
	if (CreateRaveWindow(vpwidth, vpheight))
		valid = 1;
	else
		valid = 0;
	InstallTextures("tex.txt");	
}
	
void Raver::Destroy()
{
	// need to zero out this studd as desctuctor is called explicitly
	// due to an apparent oddity in the MW Mac compiler
	InstallTextures(NULL);
#if defined(__INTEL__)
	if (drawContext)
		QADrawContextDelete(drawContext);
	if (primarySurface)
		primarySurface->Release();
	if (directDraw) {
		directDraw->RestoreDisplayMode();
		directDraw->Release();	
	}
	drawContext = NULL;
	primarySurface = NULL;
	directDraw = NULL;
#elif defined(macintosh)
	if (oldScreenDepth != 16)
		SetDepth (gDevice, oldScreenDepth, gdDevType, 1);
	oldScreenDepth = 16;
#endif
}

void Raver::TimeSlice(long keys)
{
	TQAVGouraud v1, v2, v3;
	TQAVTexture t1, t2, t3;
	TQATexture *tex = NULL;
	Tri3D *this_tri = tri_list;
/*	
	// This is the heartbeat of the system
	// It's up to the game logic what is done with the keys
	// To move the camera, call:
*/	
	Renderer::MoveWorld(keys); 
			
	// The actual rasterizing code -----------
	QARenderStart (drawContext, NULL, cache); // no cache cap in default engine
	while (this_tri) {		
		Vertex3D &v3a = vertex_list[this_tri->vi1];
		Vertex3D &v3b = vertex_list[this_tri->vi2];
		Vertex3D &v3c = vertex_list[this_tri->vi3];
		if (this_tri->GetClip(vertex_list)) {
			if (this_tri->texmap > 0 && this_tri->texmap < num_textures) {
				tex = texTable[this_tri->texmap].tp;
				if (tex) {
					QASetPtr (drawContext, kQATag_Texture, tex);
					t1.x = v3a.pix_point.x;
					t1.y = v3a.pix_point.y;
					t1.z = v3a.invZ; 
					t1.invW = v3a.invZ;;
					t1.a = 1.0f;
					t1.r = 1.0f;
					t1.g = 1.0f;
					t1.b = 1.0f;
					t1.uOverW = v3a.u;
					t1.vOverW = v3a.v;

					t2.x = v3b.pix_point.x;
					t2.y = v3b.pix_point.y;
					t2.z = v3b.invZ; 
					t2.invW = v3b.invZ;
					t2.a = 1.0f;
					t2.r = 1.0f;
					t2.g = 1.0f;
					t2.b = 1.0f;
					t2.uOverW = v3b.u;
					t2.vOverW = v3b.v;

					t3.x = v3c.pix_point.x;
					t3.y = v3c.pix_point.y;
					t3.z = v3c.invZ; 
					t3.invW = v3c.invZ;
					t3.a = 1.0f;
					t3.r = 1.0f;
					t3.g = 1.0f;
					t3.b = 1.0f;
					t3.uOverW = v3c.u;
					t3.vOverW = v3c.v;
			
					QADrawTriTexture (drawContext, &t1, &t2, &t3, kQATriFlags_None);
				}
			}			
			else {
				v1.x = v3a.pix_point.x;
				v1.y = v3a.pix_point.y;
				v1.z = v3a.invZ; 
				v1.invW = 1;;
				v1.a = 1.0f;

				v2.x = v3b.pix_point.x;
				v2.y = v3b.pix_point.y;
				v2.z = v3b.invZ; 
				v2.invW = 1;;
				v2.a = 1.0f;

				v3.x = v3c.pix_point.x;
				v3.y = v3c.pix_point.y;
				v3.z = v3c.invZ; 
				v3.invW = 1;;
				v3.a = 1.0f;
				
				/*
				if (this_tri->type == TRI_MOVEABLE) { // calc lighting dynamically
					// no-op for this demo
				}
				else {
				*/
					v1.r = this_tri->rgb1.r;
					v1.g = this_tri->rgb1.g;
					v1.b = this_tri->rgb1.b;
					
					v2.r = this_tri->rgb2.r;
					v2.g = this_tri->rgb2.g;
					v2.b = this_tri->rgb2.b;
					
					v3.r = this_tri->rgb3.r;
					v3.g = this_tri->rgb3.g;
					v3.b = this_tri->rgb3.b;			
			/*	} */
				QADrawTriGouraud (drawContext, &v1, &v2, &v3, kQATriFlags_None);
			}
		}
		this_tri = this_tri->next;
	}		
	QARenderEnd (drawContext, NULL);		
}

void Raver::InitTexTable()
{
	for (int n = 0; n < 256; n++) {
		texTable[n].c = 0;
		texTable[n].tp = 0;
	}
}

int  Raver::InsertTexture(char tag, char *tex_data, int w, int h)
{
	if ((texTable[tag].tp = CreateRaveTexture(tex_data, w, h)) != NULL)
		return 1;
	return 0;
}

int Raver::InstallTextures(char *list_name)
{	
	
	char *buffer, *bufPtr, *nextLine, theLine[80], tex_char_name[64];
	int n;
	char c;
		
	// we're going to keep this real simple:
	// as we are using a text-based map, we'll assume the maximum
	// range is 0-255, (single byte ASCII codes) 
	// so we'll simply make a table that indexes the value
	// to the texture
	
	for (n = 0; n < 256; n++) {
		if (texTable[n].tp) {
			QATextureDelete(engine, texTable[n].tp);
			texTable[n].tp = 0;
			texTable[n].c = 0;
		}
	}
	
	if (list_name == NULL) return 0; // clear operation	
	
	if (LoadLocal2Buffer(list_name, &buffer)) {
		bufPtr = buffer;
		for (n = 0; n < 256; n++) {
			nextLine = ReadNextLine(bufPtr, theLine, 256);
			if (theLine) {
				if (sscanf(theLine, "%c %s", &c, tex_char_name)) {
					texTable[c].c = c;
					texTable[c].tp = CreateRaveTexture(tex_char_name);
				}
			}
			if (nextLine)
				bufPtr = nextLine;
			else
				break;		
		}
		delete buffer;
		return 1;
	}
	return 0;
}

void Raver::SetupPointGrid(int res)
{
	if (pointGrid) delete pointGrid;
	gridResolution = res;
	gridWidth = viewport_width/gridResolution + 1;
	gridHeight = viewport_height/gridResolution + 1;
	pointGrid = new Rgb[gridWidth * gridHeight];
	if (!pointGrid) {
		Error("Insufficient memory to init tables");
		valid = 0;
		mem_alloc_error++;
	}
}

void Raver::DrawDot(int x, int y, float r, float g, float b)
{
	TQAVGouraud v;
	
	if (x >= viewport_width) x = viewport_width - 1;
	if (y >= viewport_height) y = viewport_height - 1;
	v.x = (float)x;
	v.y = (float)y;
	v.z = 0.0f;
	v.invW = 1.0f;
	v.a = 1.0f;
	v.r = r;
	v.g = g;
	v.b = b;
	QADrawPoint (drawContext, &v);
}

TQAEngine *Raver::SetupEngine(TQADevice *device)
{
	TQAEngine *eng;	
	num_engines	= 0;
	TQAError err;
	unsigned long response;
	
	for (
		eng = QADeviceGetFirstEngine(device);
		eng; 
		eng = QADeviceGetNextEngine(device, eng), num_engines++)
		;
					
	// if num_eng > 1, this is where we should test the suitability of the 
	// available engines for our purpose. For this demo, we'll use the 
	// RAVE-recommended version (the first one)

	if (num_engines) {
		eng = QADeviceGetFirstEngine(device);		
		err = QAEngineGestalt(eng, kQAGestalt_OptionalFeatures, &response);
		if (!err) {
			//if (response & kQAOptional_PerspectiveZ)
			//	perspectiveZ = true;
			return QADeviceGetFirstEngine(device);
		}
	}
	return NULL;
}

TQATexture *Raver::CreateRaveTexture(char *data, int w, int h)
{
	TQAError raveErr;
	TQAImage raveImage;
	TQATexture *raveTexture = NULL;

	raveImage.rowBytes = w * 2;
	raveImage.width = w;
	raveImage.height = h;
	raveImage.pixmap = data;		
	if (!QATextureNew(engine, kQATexture_None, kQAPixel_RGB16, &raveImage, &raveTexture))
		raveErr = QATextureDetach(engine, raveTexture);
	return raveTexture;
}

TQATexture *Raver::CreateRaveTexture(char *tex_name)
{
	TQAError raveErr;
	TQAImage raveImage;	
	TQATexture *raveTexture = NULL;

	unsigned char header[4] = { ' ', ' ', 0, 0}; // knock-up header for demo
	int L = strlen(tex_name), eL = 4;
	char *ext, *name_copy = new char[L + 1];	
	char *bmTex_name = new char[L + eL + 1];
	strcpy(bmTex_name, tex_name);
	
	if ((ext = strstr(bmTex_name, ".")) != NULL) {
		strcpy(ext, ".mcb");
		FILE *fp = fopen(bmTex_name, "rb");
		if (fp) {
			// load raw bitmap			
			fread(header, 4, 1, fp);
			if (header[0] == 'M' && header[1] == 'C') {
				int w = (int)header[2] + 1;
				int h = (int)header[3] + 1;
				int buffSize = w * h * 2;
				char *bits = new char[buffSize]; // 16 bit color expected
				if (bits) {
					fread(bits, buffSize, 1, fp); 
					raveImage.rowBytes = w * 2;
					raveImage.width = w;
					raveImage.height = h;
					raveImage.pixmap = bits;
#if defined (__INTEL__)					
					// Now convert shorts to Intel format if necessary
					short *pairs = (short*)bits;
					for (int row = 0; row < h; row++) {
						for (int col = 0; col < w; col++) {
							short s = *(pairs + row * w + col);
							short t = s;
							s >>= 8;
							s |= (t << 8);
							*(pairs + row * w + col) = s;
						}
					}	
#endif					
					if (!QATextureNew(engine, kQATexture_None, kQAPixel_RGB16, &raveImage, &raveTexture))
						raveErr = QATextureDetach(engine, raveTexture);							
					delete [] bits;
				}	
			}
			fclose(fp);
		}

#if defined(macintosh)
		
		else {
			PixMapInfo pmtex(TEXBUFFWIDTH, TEXBUFFHEIGHT);
			if (pmtex.LoadPictPixels(tex_name)) {
				raveImage.rowBytes = pmtex.rowBytes;
				raveImage.width = pmtex.width;
				raveImage.height = pmtex.height;
				raveImage.pixmap = pmtex.base;
				
				if (!QATextureNew(engine, kQATexture_None, kQAPixel_RGB16, &raveImage, &raveTexture))
					raveErr = QATextureDetach(engine, raveTexture);
				// Create the x-platform raw version while we're here
				FILE *fp = fopen(bmTex_name, "wb");
				if (fp) {
					header[0] = 'M';
					header[1] = 'C';
					// NOTE limitation of 256 dimension texmap!
					header[2] = (unsigned char)(pmtex.width - 1); // offset by 1 to fit
					header[3] = (unsigned char)(pmtex.height - 1);
					fwrite(header, 4, 1, fp);
					for (int y = 0; y < pmtex.height; y++)						
						fwrite(pmtex.base + y * pmtex.rowBytes, pmtex.width, sizeof(short), fp);
					fclose(fp);
				}
				pmtex.Reset();		
			}
		}
#endif
				
	}
	return raveTexture;
}

int Raver::CreateRaveWindow(int vpw, int vph)
{
	TQADevice raveDevice;	
		
#if defined(macintosh)
	vpw; vph;
	if (window) {
		if (oldScreenDepth != 16)
			SetDepth (gDevice, 16, gdDevType, 1);				
		raveDevice.deviceType = kQADeviceGDevice;
		raveDevice.device.gDevice = gDevice;
		if ((engine = SetupEngine(&raveDevice)) != NULL) {
			if (CreateDrawContext(&raveDevice, kQAContext_DoubleBuffer))
				return 1;								
		}			
	}	
	
#elif defined(__INTEL__) 
	HRESULT             ddrval;
	DDSURFACEDESC		ddsd;
	DDPIXELFORMAT 		ddpf;
	
	if (window) {				
		ShowWindow(window, SW_SHOW);
		DirectDrawCreate( NULL, &directDraw, NULL);			
		if (directDraw)	  { 
			//directDraw->SetCooperativeLevel(window, DDSCL_NORMAL);						
	    	directDraw->SetCooperativeLevel(window, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
	    	ddrval = directDraw->SetDisplayMode(vpw, vph, 16);

	    	if (ddrval == DD_OK)
	    		SetWindowPos(window, HWND_NOTOPMOST, 0, 0, vpw, vph, SWP_SHOWWINDOW);
	    	else {		    		
				windowRect.left = 0;
				windowRect.top = 0;
				windowRect.right = GetSystemMetrics(SM_CXFULLSCREEN);
				windowRect.bottom = GetSystemMetrics(SM_CYFULLSCREEN);
				Shrink(&windowRect, vpw, vph);
				SetWindowPos(window, HWND_NOTOPMOST, windowRect.left, windowRect.top, 
					vpw, vph, SWP_SHOWWINDOW);	    		
	    	}
	    	
			ddsd.dwSize = sizeof(DDSURFACEDESC);
			ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH/* | DDSD_PIXELFORMAT*/;
			ddsd.dwHeight = vpw;
			ddsd.dwWidth = vph;
			ddpf.dwSize = sizeof(DDPIXELFORMAT);
			ddpf.dwFlags = DDPF_RGB;
			ddpf.dwRGBBitCount = DDBD_16;
			ddsd.ddpfPixelFormat = ddpf;
			ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;		
			ddrval = directDraw->CreateSurface(&ddsd, &primarySurface, NULL);		
	        if (primarySurface) {
				raveDevice.device.hdc = GetDC(window);
				raveDevice.deviceType = kQADeviceDDSurface;	        
	        	raveDevice.device.lpDirectDraw = directDraw;
	        	raveDevice.device.lpDirectDrawSurface = primarySurface;
				if ((engine = SetupEngine(&raveDevice)) != NULL) {
					if (CreateDrawContext(&raveDevice, kQAContext_DoubleBuffer))
						return 1;												
				}
				primarySurface->Release();
				primarySurface = NULL;				
			}
		}
		
		// Fall thru: Try regular DC
		raveDevice.deviceType = kQADeviceWin32DC;
		raveDevice.device.hdc = GetDC(window);		
		if ((engine = SetupEngine(&raveDevice)) != NULL) {
			if (CreateDrawContext(&raveDevice, kQAContext_DoubleBuffer))
				return 1;							
		}
	}	

#endif // INTEL

	return 0;
}

int Raver::CreateDrawContext(TQADevice *pRaveDevice, unsigned long flags)
{
	TQARect				tqRect;	
	TQAError			status;
	TQAClip				clip;
	
#if defined(macintosh)
	
	if (engine) {
		tqRect.top = windowRect.top;
		tqRect.left = windowRect.left;
		tqRect.bottom = windowRect.bottom;
		tqRect.right = windowRect.right;
		
		clip.clipType = kQAClipRgn;
		clip.clip.clipRgn = clipRegion;
		
		status = QADrawContextNew (pRaveDevice, &tqRect,
				clipping ? &clip : NULL, engine, flags, &drawContext);
		
		if (status != kQANoErr)
			return 0;
	}
	else {
		drawContext = NULL;
		return 0;
	}

#elif defined(__INTEL__) // end MAC

	RECT		aWinRect;

	if (engine) {
		GetClientRect(window, (LPRECT)&aWinRect);
		tqRect.top = windowRect.top;
		tqRect.left = windowRect.left;
		tqRect.bottom = windowRect.bottom;
		tqRect.right = windowRect.right;
		
		clip.clipType = kQAClipWin32Rgn;
		clip.clip.clipRgn = clipRegion;
		
		status = QADrawContextNew (pRaveDevice, &tqRect,
				clipping ? &clip : NULL, engine, flags, &drawContext);
		if (status != kQANoErr)
			return 0;
	}
	else {
		drawContext = NULL;
		return 0;
	}

#endif // INTEL
	
	if (perspectiveZ)
		QASetInt(drawContext, kQATag_PerspectiveZ, kQAPerspectiveZ_On);
	return 1;
}

void Raver::DumpInfo()
{
	printf("WX: %f\nWY: %f\nWZ: %f\nRX: %f\nRY: %f\nRZ: %f\n",
		Vector3D::worldPos_X, Vector3D::worldPos_Y, Vector3D::worldPos_Z,
		Vector3D::worldRot_X, Vector3D::worldRot_Y, Vector3D::worldRot_Z);
}

void Raver::Load()
{		
	/*--------------- this part for testing only: -----------------------------*/
	
	Rgb s(0.0, 1.0, 0.0);
	Rgb e(1.0, 0.0, 0.0);
	Rgb c(0.0, 0.0, 1.0);
	
	Texture16 tex(128, 128);
	char * dat = tex.CreateWashTB(s, e);
	InsertTexture('A', dat, 128, 128);

	Texture16 tex2(128, 128);
	char * dat2 = tex.CreateFlatColor(c);
	InsertTexture('B', dat2, 128, 128);

	Texture16 tex3(128, 128);
	char * dat3 = tex.CreateFlatColor(s);
	InsertTexture('C', dat3, 128, 128);
	
	CreateTransformPanel(8, 8, 5, 5, 0.5, 0.1, 0.4, 	-5, -2, 50,	0, 0, 0, 'b');
	CreateTransformPanel(8, 8, 5, 5, 0.5, 0.1, 0.4, 	5, -8, 55, 0, 0, 0, 'A');
	CreateTransformPanel(8, 8, 5, 5, 0.5, 0.1, 0.4, 	0, -2, 60, 0, 0, 0, 'a');
	LoadDXFTris("ball.dxf", 0, 2.0, 0.6, 0.0, 0.0, 		-2.0, -2.0, 20.0, 0, 0, 0);
	LoadDXFTris("ball.dxf", 'c', 1.0, 0.0, 0.6, 0.0, 	0.0, -1.0, 15.0, 0, 0, 0);
	LoadDXFTris("ball.dxf", 0, 0.5, 0.0, 0.0, 0.6, 		2.0, 2.0, 10.0, 0, 0, 0);
	
	/*---------------------------------------------------------------------------*/
	
}

