// OwnrTree.cpp : implementation file
//

#include "stdafx.h"
#include "CustTree.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define INSERT_TEXT ""


/////////////////////////////////////////////////////////////////////
// CCustomTreeCtrl

/////////////////////////////////////////////////////////////////////
// CCustomTreeCtrl Construction

CCustomTreeCtrl::CCustomTreeCtrl()
{
	m_bNoPaint = FALSE ;
}

/////////////////////////////////////////////////////////////////////
// CCustomTreeCtrl Public Interfaces

BOOL CCustomTreeCtrl::SetItemText(HTREEITEM hItem, LPCTSTR lpszItem)
{
	CString	cstr ;
	CRect	crect ;

	cstr = lpszItem ;

	AddTextItem( hItem, cstr ) ;

	GetItemRect( hItem, &crect, FALSE ) ;
	InvalidateRect( &crect ) ;

	return TRUE ;	
}

CString CCustomTreeCtrl::GetItemText( HTREEITEM hItem ) 
{
	CString cstr ;

	GetTextFromItem( hItem, cstr ) ;

	return cstr ;
}
  
HTREEITEM CCustomTreeCtrl::InsertItem(LPTV_INSERTSTRUCT 
											lpInsertStruct)
{
	HTREEITEM hItem ;
	CString cstr ;

	cstr = lpInsertStruct->item.pszText ;

	lpInsertStruct->item.pszText = INSERT_TEXT ;

	hItem = CTreeCtrl::InsertItem( lpInsertStruct ) ;
	if( !hItem )
		return NULL ;

	AddTextItem( hItem, cstr ) ;
	
	return hItem ;
}
  
HTREEITEM CCustomTreeCtrl::InsertItem(UINT nMask, LPCTSTR lpszItem, 
										int nImage, 
										int nSelectedImage, 
										UINT nState,UINT nStateMask,
										LPARAM lParam, 
										HTREEITEM hParent, 
										HTREEITEM hInsertAfter )
{
	CString		cstr ;
	HTREEITEM	hItem ;

	hItem = CTreeCtrl::InsertItem( nMask, INSERT_TEXT, nImage, 
									nSelectedImage, nState, 
									nStateMask, lParam, hParent, 
									hInsertAfter ) ; 
	if( !hItem )
		return NULL ;

	cstr = lpszItem ;

	AddTextItem( hItem, cstr ) ;

	return hItem ;

}
  
HTREEITEM CCustomTreeCtrl::InsertItem( LPCTSTR lpszItem, 
										HTREEITEM hParent, 
										HTREEITEM hInsertAfter )
{
	CString		cstr ;
	HTREEITEM	hItem ;

	cstr = lpszItem ;
	hItem = CTreeCtrl::InsertItem( INSERT_TEXT, hParent, 
									hInsertAfter ) ;
	if( !hItem )
		return NULL ;

	AddTextItem( hItem, cstr ) ;

	return hItem ;
}
  
HTREEITEM CCustomTreeCtrl::InsertItem( LPCTSTR lpszItem, int nImage, 
										int nSelectedImage, 
										HTREEITEM hParent, 
										HTREEITEM hInsertAfter)
{
	CString		cstr ;
	HTREEITEM	hItem ;

	cstr = lpszItem ;

	hItem = CTreeCtrl::InsertItem(INSERT_TEXT, nImage,nSelectedImage,
									hParent, hInsertAfter) ;
	if( !hItem )
		return NULL ;

	AddTextItem( hItem, cstr ) ;

	return hItem ;
}

BOOL CCustomTreeCtrl::GetItem( TV_ITEM* pItem )
{
	BOOL	bRet ;	
	CString	cstr ;

	bRet = CTreeCtrl::GetItem( pItem ) ;

	if( bRet )
	{
		GetTextFromItem( pItem->hItem, cstr ) ;
		strncpy( pItem->pszText, cstr, pItem->cchTextMax ) ;
	}

	return bRet ;
}

BOOL CCustomTreeCtrl::SetItem( TV_ITEM* pItem )
{
	BOOL	bRet ;
	CString	cstr ;
	
	cstr = pItem->pszText ;
	pItem->pszText = INSERT_TEXT ;
	bRet = CTreeCtrl::SetItem( pItem ) ;

	if( bRet )
	{
		AddTextItem( pItem->hItem, cstr ) ;	
	}

	return bRet ;
}

BOOL CCustomTreeCtrl::SetItem( HTREEITEM hItem, UINT nMask, 
							  LPCTSTR lpszItem, int nImage, 
							  int nSelectedImage, UINT nState, 
							  UINT nStateMask, LPARAM lParam )
{
	BOOL	bRet ;
	
	bRet = CTreeCtrl::SetItem( hItem, nMask, INSERT_TEXT, nImage, 
								nSelectedImage, nState, nStateMask, 
								lParam ) ;

	if( bRet )
	{
		CString	cstr ;
		cstr = lpszItem ;
		AddTextItem( hItem, cstr ) ;	
	}

	return TRUE ;
}


/////////////////////////////////////////////////////////////////////
// CCustomTreeCtrl Implementation Methods

HTREEITEM CCustomTreeCtrl::PtInField( POINT pt )
{
	CRect		crect ;
	HTREEITEM	htreeitem ;

	htreeitem = GetFirstVisibleItem();
		
	while( htreeitem )
	{
		GetItemRect( htreeitem, &crect, TRUE ) ;
		if( crect.PtInRect( pt ) )
			break ;
		
		htreeitem = GetNextVisibleItem( htreeitem ) ;
	}

	return htreeitem ;
}

void CCustomTreeCtrl::AddTextItem( HTREEITEM hItem, CString &cstr )
{	
	m_cmapTextItems.SetAt( hItem, cstr ) ;
}

void CCustomTreeCtrl::RemoveTextItem( HTREEITEM hItem )
{	
	m_cmapTextItems.RemoveKey( hItem ) ;
}

BOOL CCustomTreeCtrl::GetTextFromItem(HTREEITEM hItem, CString &cstr)
{
	return m_cmapTextItems.Lookup( hItem, cstr ) ;
}

void CCustomTreeCtrl::SetItemWidth( HTREEITEM htreeitem, CDC &cdc, 
									DWORD dwWidth )
{
	int			nSpaceWidth, nSpaces ;
	CString		cstr ;

	cdc.GetCharWidth( ' ', ' ', &nSpaceWidth ) ;
	
	// I don't know when a space wouldn't have width, but I would 
	// hate to see a divide by zero error.
	if( !nSpaceWidth )
		return ;

	nSpaces = dwWidth / nSpaceWidth + ( (dwWidth % nSpaceWidth)?1:0);

	cstr = CTreeCtrl::GetItemText( htreeitem ) ;
	if( cstr.GetLength() != nSpaces )
	{
		CTreeCtrl::SetItemText( htreeitem, CString(' ', nSpaces)) ;
	}
}

/////////////////////////////////////////////////////////////////////
// CCustomTreeCtrl Overidables

// This function should normally be overridden, however it is always 
// nice to have a default implementation to fall back on
DWORD CCustomTreeCtrl::DrawItem( HTREEITEM htreeitem, CDC &cdc, 
								CRect &crect, UINT nState )
{
	COLORREF rgbHighlight, rgbHighlightText ;
	CRect	crectTemp, crectSize ;

	
	if( nState & TVIS_SELECTED )
	{
		
		rgbHighlight = GetSysColor( COLOR_HIGHLIGHT ) ;
		rgbHighlightText = GetSysColor( COLOR_HIGHLIGHTTEXT ) ;

		crectTemp.top = crectTemp.left = 0 ;
		cdc.DrawText( GetItemText( htreeitem ), &crectTemp,
						DT_SINGLELINE | DT_CALCRECT ) ;
		
		crect.right = crect.left + 4 + crectTemp.right ;
		cdc.FillSolidRect( &crect, rgbHighlight ) ;
		rgbHighlightText = cdc.SetTextColor( rgbHighlightText ) ;
		rgbHighlight = cdc.SetBkColor( rgbHighlight ) ;
		
		crect.left+= 2 ;
		cdc.DrawText( GetItemText( htreeitem ), &crect, 
						DT_VCENTER | DT_SINGLELINE ) ;		
		crect.left-= 2 ;

		cdc.SetTextColor( rgbHighlightText ) ;
		cdc.SetBkColor( rgbHighlight ) ;

		if( GetFocus() == this )
		{
			cdc.DrawFocusRect( &crect ) ;
		}

	}else
	{
		cdc.FillSolidRect( &crect, GetSysColor( COLOR_WINDOW ) ) ;
		crect.left+=2 ;
		cdc.DrawText( GetItemText( htreeitem ), &crect, 
						DT_VCENTER | DT_SINGLELINE ) ;
		crect.left-=2 ;
	}

	crectSize.SetRectEmpty() ;
	cdc.DrawText( GetItemText( htreeitem ), &crectSize, 
					DT_VCENTER | DT_SINGLELINE | DT_CALCRECT ) ;

	return crectSize.Width() ;
}


BEGIN_MESSAGE_MAP(CCustomTreeCtrl, CTreeCtrl)
	//{{AFX_MSG_MAP(CCustomTreeCtrl)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////
// CCustomTreeCtrl message handlers

// Disable Tooltips
BOOL CCustomTreeCtrl::OnNotify(WPARAM wParam, LPARAM lParam, 
							   LRESULT* pResult) 
{
	return TRUE ;
}

void CCustomTreeCtrl::OnPaint() 
{	
	HTREEITEM	htreeitem ;
	CRect		crect, crectClient, crectInvalid, crectTemp ;
	UINT		nState ;
	BOOL		bFocus ;
	CFont		*pcfont ;
	CFont		*pcfontOld ;
	DWORD		dwWidth ;

	// If we are flagged to ignore this pain message, 
	// then validate rect and return
	if(m_bNoPaint)
	{
		m_bNoPaint = FALSE ;		
		ValidateRect( NULL ) ;
		return ;
	}	

	// Retrieve Invalid Rect for use throughout paint handler
	GetUpdateRect( &crectInvalid );	
	
	// If we have focus, store this fact, but then turn it off
	if( bFocus = GetFocus() == this )
	{
		// Make sure any paint message generated by 
		// SetFocus() does nothing
		m_bNoPaint = TRUE ;
		::SetFocus(NULL) ;

		// Make sure that or Invalid rect is the same as it 
		// was upon entering the paint handler
		ValidateRect(NULL) ;
		InvalidateRect( &crectInvalid ) ;

		// Set Paint Flag so that future paint handling will occur
		m_bNoPaint = FALSE ;
	}
	
	// Get that default drawing done... without a focus rect or 
	// selected area	
	CTreeCtrl::OnPaint() ;	

	// If we did have focus we will restore it now
	if( bFocus )
	{		
		m_bNoPaint = TRUE ;
		SetFocus() ;
		m_bNoPaint = FALSE ;
	}

	// We want a valid window rect now... SetFocus() may have 
	// invalidated some portion of the client
	ValidateRect(NULL) ;

	// This is the DC that we will use to do our drawing
	CClientDC	cdc( this ) ;	

	GetClientRect( &crectClient ) ;	
		
	// As control we need to make sure we do our drawing in 
	// our parents font
	pcfont = GetParent()->GetFont() ;
	pcfontOld = cdc.SelectObject( pcfont ) ;	

	// Now we will enumerate the visible items in the control
	htreeitem = GetFirstVisibleItem();
	while( htreeitem )
	{
		// Where is this item in the client
		GetItemRect( htreeitem, &crect, TRUE ) ;
		
		// Get the state of the current item to pass to the 
		// DrawItem() Function
		nState = GetItemState( htreeitem, ~0 ) ;

		// Expand / limit the area of the item to the right 
		// edge of the client
		crect.right = crectClient.right ;

		// If the item falls inside of our original 
		// invalid rect then redraw it
		// by calling the overidable virtual function DrawItem()
		if( crectTemp.IntersectRect( &crect, &crectInvalid ) )
		{
			dwWidth = DrawItem( htreeitem, cdc, crect, nState ) ;
			SetItemWidth( htreeitem, cdc, dwWidth ) ;
		}

		// Continue through visible items
		htreeitem = GetNextVisibleItem( htreeitem ) ;
	}
	// We do this, because SetItemWidth actually changes
	// the text of the items in the control and it 
	// may have flagged a repaint which we don't want to happen
	ValidateRect( NULL ) ;

	// Restore previous font in DC
	cdc.SelectObject( pcfontOld ) ;

}


