// CustTree.h : header file
//

/////////////////////////////////////////////////////////////////////
// CCustomTreeCtrl window

#include <afxtempl.h>


class CCustomTreeCtrl : public CTreeCtrl
{
// Construction
public:
	CCustomTreeCtrl();

// Public Interfaces
public:
	BOOL SetItemText( HTREEITEM hItem, LPCTSTR lpszItem );
	CString GetItemText( HTREEITEM hItem ) ;
	HTREEITEM InsertItem( LPTV_INSERTSTRUCT lpInsertStruct ) ;
	HTREEITEM InsertItem(UINT nMask, LPCTSTR lpszItem, int nImage, 
							int nSelectedImage, UINT nState, 
							UINT nStateMask, LPARAM lParam, 
							HTREEITEM hParent, 
							HTREEITEM hInsertAfter ) ;
	HTREEITEM InsertItem( LPCTSTR lpszItem, 
							HTREEITEM hParent = TVI_ROOT, 
							HTREEITEM hInsertAfter = TVI_LAST ) ;
	HTREEITEM InsertItem( LPCTSTR lpszItem, int nImage, 
							int nSelectedImage, 
							HTREEITEM hParent = TVI_ROOT, 
							HTREEITEM hInsertAfter = TVI_LAST) ;
	BOOL GetItem( TV_ITEM* pItem );
	BOOL SetItem( TV_ITEM* pItem );  
	BOOL SetItem( HTREEITEM hItem, UINT nMask, LPCTSTR lpszItem, 
							int nImage, int nSelectedImage, 
							UINT nState, UINT nStateMask, 
							LPARAM lParam );


// Implementation Methods
private:
	HTREEITEM PtInField( POINT pt );
	void AddTextItem( HTREEITEM hItem, CString & ) ;
	void RemoveTextItem( HTREEITEM hItem ) ;
	BOOL GetTextFromItem( HTREEITEM hItem, CString &cstr ) ;
	void SetItemWidth( HTREEITEM, CDC &cdc, DWORD dwWidth ) ;

// Implementation Member Variables
private:	
	BOOL										m_bNoPaint;
	CMap<HANDLE, HANDLE, CString, CString &>	m_cmapTextItems ;

// Overidables
protected:
	virtual DWORD DrawItem( HTREEITEM, CDC &, CRect &, UINT );

// Overrides
private:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCustomTreeCtrl)
	protected:
	virtual BOOL OnNotify(WPARAM wParam,
							LPARAM lParam,LRESULT* pResult);
	//}}AFX_VIRTUAL

// Generated message map functions
protected:	
	//{{AFX_MSG(CCustomTreeCtrl)
	afx_msg void OnPaint();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////
