// Indexer.cpp
#include "stdafx.h"
#include "Indexer.h"
#include "MainFrm.h"
#include "IndexerDoc.h"
#include "IndexerView.h"
#include "IndexDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// CIndexerApp
BEGIN_MESSAGE_MAP(CIndexerApp, CWinApp)
	//{{AFX_MSG_MAP(CIndexerApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

CIndexerApp::CIndexerApp()
{
	m_pCIndexDlg = new CIndexDlg;
	m_bIndexCreated = FALSE;
	m_bInitialized = FALSE;
}
CIndexerApp::~CIndexerApp()
{
	delete m_pCIndexDlg;
}

CIndexerApp theApp;

BOOL CIndexerApp::InitInstance()
{
#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif
	SetRegistryKey("Al Stevens Programs");
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CIndexerDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CIndexerView));
	AddDocTemplate(pDocTemplate);
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();
	m_pMainWnd->DragAcceptFiles(FALSE);
	m_bInitialized = TRUE;
	return TRUE;
}
void CIndexerApp::OnAppAbout()
{
	struct CAboutDlg:CDialog { CAboutDlg():CDialog(IDD_ABOUTBOX){ } } aboutDlg;
	aboutDlg.DoModal();
}
// ---- get a pointer to the document object
CIndexerDoc* CIndexerApp::GetDoc()
{
	POSITION tpos = GetFirstDocTemplatePosition();
	if (tpos != 0)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		if (dpos != 0)	{
			CIndexerDoc* pDoc = static_cast<CIndexerDoc*>(pTem->GetNextDoc(dpos));
			ASSERT(pDoc != 0);
			return pDoc;
		}
	}
	return 0;
}
// ---- get a pointer to the view object
CIndexerView* CIndexerApp::GetView()
{
	CIndexerDoc* pDoc = GetDoc();
	if (pDoc != 0)	{
		POSITION vpos = pDoc->GetFirstViewPosition();
		ASSERT(vpos != 0);
		CIndexerView* pView = static_cast<CIndexerView*>(pDoc->GetNextView(vpos));
		ASSERT(pView != 0);
		return pView;
	}
	return 0;
}
void CIndexerApp::BuildIndexDisplay(const CStringArray& rastrFinal)
{
	ASSERT(m_pCIndexDlg != 0);
	if (m_bIndexCreated != TRUE)	{
		m_pCIndexDlg->Create(IDD_INDEXDLG);
		m_bIndexCreated = TRUE;
	}

	m_pCIndexDlg->m_IndexList.ResetContent();

	int nEntries = rastrFinal.GetSize();
	for (int i = 0; i < nEntries; i++)
		m_pCIndexDlg->m_IndexList.AddString(rastrFinal[i]);

	m_pCIndexDlg->ShowWindow(SW_SHOW);
	m_pCIndexDlg->SetFocus();
}
void CIndexerApp::SaveIndex()
{
	CIndexerView* pView = theApp.GetView();
	if (pView != 0)
		pView->SaveIndex();
}
void CIndexerApp::SelectEntry(int sel)
{
	CIndexerView* pView = theApp.GetView();
	if (pView != 0)
		pView->SelectEntry(sel);
}
void CIndexerApp::SaveWindowPosition(const CString& strWindow, CWnd* pWnd)
{
	WINDOWPLACEMENT wndpl = { sizeof(WINDOWPLACEMENT) };
	if (pWnd->m_hWnd != 0 && pWnd->GetWindowPlacement(&wndpl))	{
		RECT rc = wndpl.rcNormalPosition;
		WriteProfileInt(strWindow, "Left", rc.left);
		WriteProfileInt(strWindow, "Top",  rc.top);
		WriteProfileInt(strWindow, "Right", rc.right);
		WriteProfileInt(strWindow, "Bottom", rc.bottom);
	}
}
void CIndexerApp::RestoreWindowPosition(const CString& strWindow, CWnd* pWnd)
{
	WINDOWPLACEMENT wndpl = { sizeof(WINDOWPLACEMENT) };
	if (pWnd->m_hWnd != 0)	{
		pWnd->GetWindowPlacement(&wndpl);
		wndpl.rcNormalPosition.left = 
			GetProfileInt(strWindow, "Left", wndpl.rcNormalPosition.left);
		wndpl.rcNormalPosition.top = 
			GetProfileInt(strWindow, "Top", wndpl.rcNormalPosition.top);
		wndpl.rcNormalPosition.right = 
			GetProfileInt(strWindow, "Right", wndpl.rcNormalPosition.right);
		wndpl.rcNormalPosition.bottom = 
			GetProfileInt(strWindow, "Bottom", wndpl.rcNormalPosition.bottom);
		pWnd->SetWindowPlacement(&wndpl);
	}
}
