// IndexerDoc.cpp
#include "stdafx.h"
#include "Indexer.h"
#include "IndexerDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CIndexerDoc, CRichEditDoc)
BEGIN_MESSAGE_MAP(CIndexerDoc, CRichEditDoc)
	//{{AFX_MSG_MAP(CIndexerDoc)
	ON_UPDATE_COMMAND_UI(ID_PAGENO, OnUpdatePageno)
	ON_UPDATE_COMMAND_UI(ID_BUILDINDEX, OnUpdateBuildindex)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CIndexerDoc::Serialize(CArchive& ar)
{
	POSITION pos = GetFirstViewPosition();
	ASSERT(pos != NULL);
	CRichEditView* pView = static_cast<CRichEditView*>(GetNextView(pos));
	ASSERT(pView != NULL);
	pView->Serialize(ar);
	if (ar.IsStoring())
		ar.Flush();
}
BOOL CIndexerDoc::IsNdxFile() const
{
	CString& rstrPath = const_cast<CString&>(GetPathName());
	return rstrPath.IsEmpty() || rstrPath.Right(4).CompareNoCase(".ndx") == 0;
}
void CIndexerDoc::OnUpdatePageno(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(IsNdxFile());
}
void CIndexerDoc::OnUpdateBuildindex(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(IsNdxFile());
}
