// IndexerView.h

#ifndef INDEXERVIEW_H
#define INDEXERVIEW_H

class CIndexerView : public CRichEditView
{
	BOOL m_bControlDown;
	CFont newfont;
	int m_nFontHeight;
	int m_nFontWidth;
	CStringArray m_astrFinal;
	CString m_strFindText;
	CString m_strPrevHeader;
	int CurrentLineNumber();
	void BuildIndex(CString& strIndexEntry);
	BOOL DeletePageBreak(int nLineNo);
	BOOL IsPageBreak(int nLineNo);
	void InsertPageBreak(long nLineIndex, int nPageNo);
	void KeepCaretInLeftMarginOfPageBreak();
protected: // create from serialization only
	CIndexerView();
	DECLARE_DYNCREATE(CIndexerView)
public:
	virtual ~CIndexerView() { }
	CIndexerDoc* GetDocument();
	void SaveIndex();
	void SelectEntry(int sel);
	//{{AFX_VIRTUAL(CIndexerView)
	public:
	virtual void Serialize(CArchive& ar);
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	//}}AFX_VIRTUAL
// Generated message map functions
protected:
	//{{AFX_MSG(CIndexerView)
	afx_msg void OnPageno();
	afx_msg void OnBuildindex();
	afx_msg void OnFindNext();
	afx_msg void OnUpdateFindNext(CCmdUI* pCmdUI);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnPaginate();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}

#endif
