// MainFrm.cpp : implementation of the CMainFrame class

#include "stdafx.h"
#include "Indexer.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
};
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	WINDOWPLACEMENT wp;
	if (LoadWindowPlacement(&wp))	{
		wp.showCmd = AfxGetApp()->m_nCmdShow;
		SetWindowPlacement(&wp);
	}
	CFrameWnd::OnCreate(lpCreateStruct);
	m_wndToolBar.Create(this);
	m_wndToolBar.LoadToolBar(IDR_MAINFRAME);
	m_wndStatusBar.Create(this);
	m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT));
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);
	return 0;
}
BOOL CMainFrame::LoadWindowPlacement (LPWINDOWPLACEMENT pwp)
{
	CString strBuffer = AfxGetApp()->GetProfileString("Settings", "WindowPos");
	if (strBuffer.IsEmpty())
		return FALSE;
	int cRead = _stscanf(strBuffer, "%i:%i:%i:%i:%i:%i:%i:%i:%i:%i",
			&pwp->flags, &pwp->showCmd,
			&pwp->ptMinPosition.x, &pwp->ptMinPosition.y,
			&pwp->ptMaxPosition.x, &pwp->ptMaxPosition.y,
			&pwp->rcNormalPosition.left, &pwp->rcNormalPosition.top,
			&pwp->rcNormalPosition.right, &pwp->rcNormalPosition.bottom);

	if (cRead != 10)
		return FALSE;
	return TRUE;
}
VOID CMainFrame::SaveWindowPlacement (LPWINDOWPLACEMENT pwp)
{
	CString strBuffer;
	strBuffer.Format ("%i:%i:%i:%i:%i:%i:%i:%i:%i:%i",
		pwp->flags, pwp->showCmd,
		pwp->ptMinPosition.x, pwp->ptMinPosition.y,
		pwp->ptMaxPosition.x, pwp->ptMaxPosition.y,
		pwp->rcNormalPosition.left, pwp->rcNormalPosition.top,
		pwp->rcNormalPosition.right, pwp->rcNormalPosition.bottom);
	AfxGetApp ()->WriteProfileString ("Settings", "WindowPos", strBuffer);
}
void CMainFrame::OnClose() 
{
	WINDOWPLACEMENT wp;
	if (GetWindowPlacement(&wp))	{
		if (IsZoomed())
			wp.flags |= WPF_RESTORETOMAXIMIZED;
		SaveWindowPlacement(&wp);
	}
	CFrameWnd::OnClose();
}
