#ifndef _EXTARRAY_H
#define _EXTARRAY_H

#include "platform.h"

typedef struct _arrayNode
{
    charP theKey;
    void *userData;
} arrayNode;

typedef struct _arrayNode * arrayNodeP;

typedef struct _extArray
{
    ulong size, maxSize, minSize;
    arrayNodeP theList;
} extArray;

typedef struct _extArray *extArrayP;

/********************************************************************/
/* Public Function Prototypes */

extArrayP EANew(ulong minSize, ulong startSize);

void EADestroy(extArrayP *pArray);

int  EAAddElement(extArrayP theArray, charP theKey, void *userData);

int  EADeleteElement(extArrayP theArray, charP theKey);

void *EAFindElement(extArrayP theArray, charP theKey);

#endif

