/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
  $Id: AckMessage.java,v 1.23 1997/04/09 21:12:43 kiniry Exp $
  */

package info.net;

import java.io.*;
import java.net.*;
import java.util.*;

/**
 * This is the dummy message which is sent back to any sending
 * MailDaemon in response to receiving a message packet.  It in itself
 * holds no info but future versions might change that (we can piggy-
 * back all sorts of information on an ACK.)<P>
 * The real point of interest with AckMessages is their associated
 * ids, which are packed in with the SplitMessage object.  See the
 * main code for what is really going on.
 * 
 * @author Luke Weisman
 * @author Wesley Tanaka
 * @author Adam Rifkin
 * @version 1.0b2 $Revision: 1.23 $ $Date: 1997/04/09 21:12:43 $
 * @see DataInputStream
 * @see DataOutputStream
 * @see InvalidMessageException
 * @see java.io.IOException
 */

class AckMessage extends NumberMessage 
{
  
  public static final int OKAY = 0;
  public static final int CORRUPT = 1;
  public static final int ACCESS = 2;   //the sent message possabilities
  
  public static final int NEW_RECEIVER = 3;
  //this means the receiver got a message with an id on it which
  //is greater than 0, when the receiver has never gotten a message
  //from the sender at all.
  
  public static final int NO_MAILBOX = 4;
  
  int status;
  int sender_id;
  

  // constructors

  public AckMessage() 
  {
    // empty
  }
  
  public AckMessage( int val )
  {
    super( val );
  }
  
  public AckMessage( int val, int status )
  {
    super( val );
    this.status = status;
  }
  
  public boolean bad( )
  {
    return this.status > 0;
  }
  
  public int status( )
  {
    return this.status;
  }
  
  public String toString( )
  {
    String s = super.toString();
    if ( bad() )
      {
        s += "[";
        switch( status ) {
        case CORRUPT: 
          s += "corrupt";
          break;
        case ACCESS:
          s += "access";
          break;
        case NEW_RECEIVER:
          s += "new receiver";
          break;
        case NO_MAILBOX:
          s += "no mailbox";
          break;
        default:
          s += "bad for unknown reason";
        }
        s += "]";
      }
    return s;
  }
  
  public void writeData( DataOutputStream dos )
    throws IOException
  {
    super.writeData( dos );
    dos.writeInt( status );
  }
  
  public void readData( DataInputStream dis )
    throws IOException, InvalidMessageException
  {
    super.readData( dis );
    status = dis.readInt( );
  }

} // end of AckMessage class
