/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: BlockSendbox.java,v 1.9 1997/05/29 07:06:52 kiniry Exp $
 */

package info.net;

/**
 * Not finished yet.
 **/
// Excuse me??  Houston, we have a problem... -- Adam

class BlockSendbox extends Sendbox
{
  // instance variables
  
  /**
   * This is the result of a send.  True means acknowledged.  It is
   * a field so different threads can gain access to it.
   **/

  boolean waitResult;
  

  // constructors

  public BlockSendbox( MailDaemon md, String name, Place p )
    throws MailDaemonException
  {
    super( md, name, p );
  }
  public BlockSendbox( MailDaemon md )
  {
    super( md );
  }
  public BlockSendbox( MailDaemon md, String n )
    throws MailDaemonException 
  {
    super( md, n );
  }
  public BlockSendbox( MailDaemon md, Place p )
  {
    super( md, p );
  }


  // methods
  
  /**
   * Waits for an ack to arrive, or for its time to expire.  0 means
   * wait forever.
   * @exception InterruptedException if the waiting thread gets an
   *            interrupt call.
   * @exception TimeoutException if the waiting thread
   *            times out before acknowledgment is received.
   */
  synchronized public void blockForAck( long time )
    throws InterruptedException, TimeoutException
  {
    waitResult = false;
    
    //wait for the ack
    wait( time );
    
    if ( !waitResult )
      throw new TimeoutException( "Duration of " + time + " milliseconds "
                                  + "has passed without acknowledgement." );
  }
  
  
  public void send( Message msg, long time )
    throws InterruptedException, TimeoutException
  {
    //set timeout for the message.
    setMinTimeout( time );
    
    send( msg );
    
    blockForAck( time );
  }
  
  
  
  /**
   * If the message times out, then bail.
   */
  protected boolean timeOut( Message msg, Place to )
  {
    mailDaemon.purgeAddress( to, this );
    waitResult = false;
    notify();
    
    //we don't want to send the message again.
    return false;
  }
  
  
  synchronized protected boolean insertMessage (int time, 
                                                Message m, 
                                                Place from )
    throws MailDaemonException
  {
    if ( super.insertMessage( time, m, from ) )
      {
        notify();

        return true;
      }
    else
      return false;
  }

} // end of class BlockSendbox
