/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: DenyMessage.java,v 1.13 1997/04/08 22:16:11 kiniry Exp $
 */

package info.net;

import java.util.*;
import java.net.*;

/**
 * DenyMessages are sent to a sending mailbox when a receiving end of a 
 * connection for one reason or another does not accept an arriving 
 * message.  <P>
 * This is also used by the Sync mailboxs to send acknowledgements of
 * message receipt.  (This is the ACK value, below.)
 */

public class DenyMessage extends NumberMessage 
{

  /**
   * A message acknowledge from a SyncInbox to a SyncSend
   * is a DenyMessage of this value.
   */
  public static final int ACK = AckMessage.OKAY;

  /**
   * When there is no receiving mailbox of the specified name, it returns
   * this value.
   */
  public static final int NO_PORTLET = AckMessage.NO_MAILBOX;

  /**
   * When a message can not be parsed into an object for some reason.
   */
  public static final int CORRUPT_MESSAGE = AckMessage.CORRUPT;
  /**
   * When a Message class is not a public class.
   */
  public static final int ACCESS_ERROR = AckMessage.ACCESS;
  /*
   * If the id of the maildaemon does not match the id of message arriving.
   */
  public static final int WRONG_MAILDAEMON = AckMessage.NEW_RECEIVER;

  //deny specific
  /**
   * When the receiving mailbox has a filter which denys the message being
   * sent, this value is returned.
   */
  public static final int DENY = 20;


  /**
   * The constructor needed by all Message types.
   */
  public DenyMessage( )
  {
  }

  /**
   * Make a denial message for a Sendbox with the given reason.
   * @param deny_type The reason for denial of message.  The reasons can \
   * be DenyMessage.NO_PORTLET, or DenyMessage.DENY.
   */
  public DenyMessage( int deny_type ) 
  {
    super( deny_type );
  }
  
  public int reason( )
  {
    return data();
  }

  /**
   * @return true if the denial is due to a lack of target mailbox's \
   *         existence.
   */
  public boolean nobox( )
  { 
    return ( data() == NO_PORTLET );
  }


  /**
   * Turn message to string
   */
  public String toString()
  {
    return "DenyMessage: (" + data() + ")" + toString( data() );
  }


  /**
   * @return a String description of why the denial was made.
   */
  public static String toString( int tp )
  {
    switch ( tp ) {
    case DENY:
      return "Denial by filter";
      
    case NO_PORTLET:
      return "No portlet of that name";
      
    case ACK:
      return "Ack for sent message";
      
    case CORRUPT_MESSAGE:
      return "Message data could not be parsed on target machine.";

    case ACCESS_ERROR:
      return "Message sent was not a public class,"
        + " thus raising access errors.";
      
    case WRONG_MAILDAEMON:
      return "Message was being sent to maildaemon with id which was not"
        + " present.";

    default:
      return "Denial cause unknown";

    }
  }

} // end of DenyMessage class
