/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
   $Id: InMailQueue.java,v 1.23 1997/05/29 07:07:00 kiniry Exp $
*/

package info.net;

import info.util.Debug;
import java.net.*;
import java.io.*;
import java.util.*;


// This needs cleaning up.  -- Adam

/**
 * This class is used to store all the info needed to have the reliable
 * udp with a single mailbox.  
 */

class InMailQueue 
{

  /**
   * This is the port which is being maintained by the InMailQueue. 
   * It is the thing which gives the name to the InMailQueue, and which
   * gets any messages the InMailQueue gets.
   */
  private Mailbox inPort;

  /**
   * This is a table of the IDs of the last messages received from
   * all senders which have ever sent anything to this Quueue's mailbox.
   * It is used to determined which is the next expected message.
   */
  private Hashtable lastIDTable; 


  private Hashtable mdIDTable;

  /**
   * Make an InMailQueue for the passed mailbox.  Any given mailbox
   * should have exactly 1 InMailQueue.
   * @param let The mailbox to maintain.
   */
  InMailQueue( Mailbox let )
  {
    Class c;
    inPort = let;
    lastIDTable = new Hashtable();
    mdIDTable = new Hashtable();
  }
  

  /**
   * Get the Mailbox assoicated with the InMailQueue.
   */
  Mailbox Mailbox( )
  {
    return inPort;
  }

  void killMailbox( )
  {
    inPort = null;
  }

  /**
   * Make the lookup key for the remote directory of the queue.  This
   * key incorperates the MailDaemon's id on the sending side, so if
   * a new process springs up with the same mailbox names and on the
   * same port on the same machine, it will be recognizable as a 
   * different entity.
   * <p>
   * The key also disregards the Mailbox name of the sender, since the
   * mailDaemon collects all the sending mailboxs which are sending to
   * a specific receive mailbox and puts them into one block.  So the
   * ids are sequential across that entire set, so we store for the set,
   * rather than the individual.
   */
  Place generateKey( Place remote )
  {
    return remote;
  }

  /**
   * Given a return address and the id of the associated
   * MailDaemon, return the last ID value received and accepted
   * by the mailbox.  
   * @return The last ID received from remote, -1 means no message has
   *         ever been received before.
   */
  public int LastIDReceived( Place remote )
  {
    Integer lastID;

    remote = generateKey( remote );

    lastID = (Integer)lastIDTable.get(remote);
    if (lastID == null)
      {
        //never got message from this source, so last received is -1.
        lastID = new Integer(-1);
        lastIDTable.put(remote, lastID);
      }
    return lastID.intValue();
  }


  /**
   * Check to see if the mailbox wants to receive now the message
   * with the passed ID.<P>
   * Currently it only accepts messages which have IDs 1 greater
   * than the last ID received from the given sender.
   */
  public boolean WantMsg( int ID, Place remote )
  {
    if (  ID - LastIDReceived( remote ) == 1 )
      return true;
    else
      return false;
  }


  /**
   * This checks out a MailDaemonID.  It silently changes over if
   * necessary to the new maildaemon.  It compares mdIDs with the
   * assumption that newer maildaemons have larger ID values. (i.e.
   * the ids are ticks on some weak clock).
   * @return false if the message is a ghost and should be dropped.
   */
  public boolean CheckOut( Place from, long from_mdID )
  {
    from = generateKey( from );

    Long curID = (Long)mdIDTable.get(from);

    if ( curID == null )
      {
        //never got message from this source, so we are still wild.
        curID = new Long( from_mdID );
        mdIDTable.put( from, curID );

        return true;
      }
    else if ( curID.longValue() < from_mdID )
      {
        //we have a new maildaemon on the remote place.  Change over.
        Debug.lpln( 13, "Changing remote mdID to " + from_mdID
                    + " from " + curID + "." );
        lastIDTable.remove( from );
        mdIDTable.put( from, new Long( from_mdID ) );
        return true;
      }
    else if ( curID.longValue() > from_mdID )
      {
        //we have a 'ghost message' which was sent by a certainly dead
        //maildaemon.  Ignore it.
        return false;
      }
    else
      //all is well.
      return true;
  }

  /**
   * Get the value of the Ackmessage which will be sent back to the
   * sender.  This is not necessarily the id of the just received
   * message.  It returns the ID of the last message which was received
   * and accepted.
   * @param remote The place which is going to receive the ack, and which
   *               presumably just sent a message.
   */
  public int AckMsgID( Place remote )
  {
    return LastIDReceived( remote );
  }


  /**
   * Take a message, give it to the mailbox, and return true if the 
   * mailbox accepted it (it might have a filter which rejected it, or
   * the message might be an unrecognizable format, or corrupted.)
   * @param msg    The byte array which will be turned into a message (we
   *               hope.)
   * @param time   The time stamp of the message.  Every time the mail
   *               daemon receives a message, it increments a counter,
   *               this is the value of that counter.
   * @param from   The place who sent the message.
   */
  public boolean Receive( Message msg, int time, Place from )
  {
    //fix ids of messages.
    Advance( from );

    try 
      {
        return inPort.insertMessage( time, msg, from );
      }
    catch ( MailDaemonException exception )
      {
        System.err.println( "ERROR!" );
        exception.printStackTrace();
        return false;
      }
  }
  
  /**
   * This will 'fake' receive a message.  It is called when a corrupt
   * message arrives, so the ids will still work out even though the
   * message is never passed to the rp.
   */
  public void Advance( Place from )
  {
    // we know at this point that the lastID associated with this remote 
    // exists in the lastIDTable
    Place remote = generateKey( from );
    
    Integer lastID;
    lastID = (Integer)lastIDTable.get( remote );
    lastIDTable.put(remote, new Integer( lastID.intValue() + 1 ));
  }


  /**
   * Return the name of the mailbox associated with this InMailQueue.
   * @return Mailbox name.
   */
  public String name()
  {
    return inPort.name();
  }

} // end of InMailQueue class

