/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: InvalidMessageException.java,v 1.12 1997/04/08 22:16:19 kiniry Exp $
 */

package info.net;

/**
 * This exception arises when a packet arrives for a port used
 * by the mailDaemon which the MailDaemon does not recognize.<P>
 *
 * This can arise from either a non-Message derived packet arriving
 * from some alien source, or from a Message class child which is
 * not recognized by the exception-throwing program.
 *
 * @author Luke Weisman
 * @author Wesley Tanaka
 * @author Adam Rifkin
 * @version 1.0b2 $Date: 1997/04/08 22:16:19 $
 * @see Message
 * @see MailDaemonException
 */

public class InvalidMessageException extends MailDaemonException
{

  // no instance variables


  // constructors

  /**
   * Constructs a new InvalidMessageException with no detail message.
   **/

  public InvalidMessageException ()
  {
    super ("Invalid (or corrupt) Message format arrived.");
  }


  /**
   * Constructs a new InvalidMessageException of the specified class.
   * It is accessible using the toString method of the super class.
   *
   * @param className is the name of the Message class.
   **/

  public InvalidMessageException (String className)
  {
    super ("Invalid or Corrupt >" + className + "< Message arrived.");
  }


  // no methods

} // end of InvalidMessageException class
