/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: MessagePacket.java,v 1.4 1997/04/27 23:39:40 dmz Exp $
 */

package info.net;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 * This is a way to hold a message and the place that requested it be
 * sent.  Holds timeout information.
 **/

class MessagePacket 
{

  public Message msg;

  private long t_made = 0;
  private long min_duration = 0;   //min time for message times out.

  /**
   * Make new packet with given message and Mailbox name of sender.
   */

  MessagePacket( Message m, Mailbox mb )
  {
    if ( m == null )
      throw new NullPointerException( "Null message in MessagePacket()" );
    if ( mb == null )
      throw new NullPointerException( "Null Mailbox in MessagePakcet()" );

    msg = m;

    t_made = (new Date()).getTime();
    
    min_duration = mb.getMinTimeout();
  }


  boolean expired( long t )
  {
    return ( min_duration != Mailbox.NO_TIMEOUT )
      && ( t - t_made >= min_duration );
  }


  public String toString( )
  {
    return "pkg:" + (( t_made / 1000 ) % 60) + "," 
      + ( (t_made%1000 < 100) ? "0" : "" ) + ( t_made % 1000 );
  }

} // end of MessagePacket class


