/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 *  $Id: NumberMessage.java,v 1.16 1997/04/08 22:16:43 kiniry Exp $
 */

package info.net;

import java.util.*;
import java.net.*;
import java.io.*;

/* class         NumberMessage

   methods:
      byte[] writeData();                     // required by Message class
      void readData(byte [], int index);   // required by message class
      NumberMessage();                        // required by Message class
*/

/**
 * The NumberMessage class is a wrapper for an integer which allows for
 * the sending of single integers across the net through the mailboxs.
 */

public class NumberMessage extends Message 
{

  /**
   * The number in the message.
   */

  int thenumber;


  // constructors

  /**
   * This constructor is required by the message class.
   */

  public NumberMessage() 
  {
    thenumber = 0;
  }


  /**
   *  Make a NumberMessage from a given number.
   *  This allows for such things as:
   *  <pre>
   *      mySendbox.send( new NumberMessage( 42 ) );
   *  </pre>
   *  Which gives a clean way to send numbers with minimal fuss.
   */

  public NumberMessage( int number ) 
  {
    thenumber = number; 
  }
  
  /**
   * @return The value of the number message.
   */

  public int data () 
  { 
    return thenumber; 
  }


  /**
   * This is the implementation of the abstract function of the Message
   * class.  
   * @see Message
   * @param dos The stream to write the integer value to. (via the
   *            writeInt() method.)
   * @exception IOException If the dos fails for some reason.
   */

  public void writeData( DataOutputStream dos )
    throws IOException
  {
    dos.writeInt( thenumber );
  }


  /**
   * This is the implementation of the abstract function of the Message
   * class.  It simply reads in the number from the input stream.
   * @param dis The stream to pull the integer data out of.
   * @exception IOException If the dis fails for some reason.
   * @see Message
   */
  public void readData( DataInputStream dis )
    throws IOException
  {
    thenumber = dis.readInt();
  }

  /**
   * Turns the NumberMessage into a String holding the value of the number
   * in the message.
   */
  public String toString( )
  {
    return String.valueOf(thenumber);
  }

} // end of NumberMessage class
