/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: OutMailQueue.java,v 1.27 1997/04/27 23:39:44 dmz Exp $
 */

package info.net;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 * This holds a collection of OutTargetQueues bound to a specific place, 
 * all sorted by sender.
 **/

class OutMailQueue extends Hashtable
{
  /*
   * This is the ID of the MailDaemon on the receiving end of this
   * queue.
   */

  private long targ_MD_ID = MailDaemon.TARGET_ID_UNKNOWN;

  /**
   *  Add a message to the queue and get its ID value.<P>
   *
   * NOTE:
   *    Sometime we should deal with wrapping around and range
   *    checking and all of that.  So be forwarned that this 
   *    stuff doesn't happen yet.
   */

  public synchronized int AddMessage( Message msg, Mailbox from )
  {
    OutTargetQueue otq = (OutTargetQueue)get( from.name() );
    if ( otq != null )
      return otq.AddMessage( msg );
    else
      {
        otq = new OutTargetQueue( from );
        put( from.name(), otq );
        return otq.AddMessage( msg );
      }
  }

  public synchronized int PendingFrom( Mailbox from )
  {
    OutTargetQueue otq = (OutTargetQueue)get( from.name() );
    if ( otq != null )
      return otq.size();
    else
      return 0;
  }

  /**
   * Return the messages.
   */

  public Vector purgeAddress( Mailbox from )
  {
    OutTargetQueue q = (OutTargetQueue)get( from.name() );
    if ( q != null )
      {
        Vector v = new Vector();
        Enumeration e = q.elements();
        
        while( e.hasMoreElements() )
          v.addElement( ( (MessagePacket)e.nextElement() ).msg );
        
        remove( from.name() );
        return v;
      }
    else
      return new Vector();
  }

  /**
   * @return the id of the MailDaemon being sent to.
   */

  public long mdID( )
  {
    return targ_MD_ID;
  }

  public void setID( long to_id )
  {
    targ_MD_ID = to_id;
  }
  
  /** 
   * Resets all acks so it looks like no messages have ever been sent.
   */

  void resetAckNumbers( )
  {
    OutTargetQueue q;
    Enumeration e = elements();
    while( e.hasMoreElements() )
      {
        q = (OutTargetQueue) e.nextElement();
        q.resetAckNumber();
      }
  }

} // end of OutMailQueue class
