/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 *   $Id: Outbox.java,v 1.30 1997/05/29 07:07:22 kiniry Exp $
 */

package info.net;

import info.util.Debug;
import java.util.*;

// This needs a cleanup.  -- Adam

/**
 * This is the base class for all mailboxes that send messages out.  It
 * implements the doSend() method, and that is pretty much it.
 *
 * @author Adam Rifkin
 * @author Luke Weisman
 * @version 1.0b2 $Date: 1997/05/29 07:07:22 $
 */

public class Outbox extends Mailbox 
{

  /**
   * This is the minimum time for a message from being sent for a
   * timeout to be generated.  (Default value)
   */
  public static long DEFAULT_TIMEOUT = 60000;  //default 60 seconds;

  /**
   * This is the timeout time for this box.
   */
  private long timeout_time = DEFAULT_TIMEOUT;


  // constructors

  /**
   * @param md The maildaemon the Outbox will send messages through.
   * @param name The name of the mailbox.
   */
  public Outbox(MailDaemon md, String name ) 
    throws MailDaemonException
  {
    super( md, name );
  }

  /**
   * This constructor will have a name generated for the mailbox by
   * the MailDaemon.
   * @param md The maildaemon the Outbox will send messages through.
   */
  public Outbox(MailDaemon md)
  {
    super( md );
  }


  // methods

  /**
   * This sends a message to the given place. <p>
   * WARNING: Do not change the message after sending it.  The message
   *   should be considered to have been given to the info.net package
   *   at the point of sending it.  If you change it after sending it,
   *   the message arriving at the other end may in fact be changed.
   *
   * @param msg The message.
   * @param dest The destination the message is to go to.  It should be
   *             the address of some sort of Inbox.
   */
  protected void doSend(Message msg, Place dest)
  {
    Debug.push ("Outbox.doSend");
    if (msg == null)
      {
        Debug.bugExit ("Outbox doSend",
                       "Error attempting to send null message");
        throw new RuntimeException ("doSend Exception");
      }
    if (dest == null)
      {
        Debug.bugExit ("Outbox doSend",
                       "Error attempting to send message to null destination");
        throw new RuntimeException ("doSend Exception");
      }
    mailDaemon.send (msg, dest, this);
    Debug.pop ("Outbox.doSend");
  }
  

  /**
   * MessageDenial is called when a DenyMessage arrives at an OutPort.
   * It should be overridden.  This method does nothing except print 
   * a message to the screen.
   *
   * @param m The denial message holding data about why message was denied.
   * @param from The failed address.
   */
  protected void MessageDenial( DenyMessage m, Place from )
  {
    System.err.println( name() + " not getting to " + from 
                        + " because of " + m ); 
  }


  /**
   * This accepts messages, checks to see if they are DenyMessages, and
   * processes
   * them if it can. <p>
   * It should be overwritten by your own outgoing
   * mailboxes if you want to actually do anything intelligent with
   * non-deny messages.
   */
  protected boolean insertMessage(int time, Message m, Place from )
    throws MailDaemonException
  {
    try
      {
        DenyMessage dm = (DenyMessage)m;
        
        MessageDenial( dm, from );
      }
    catch ( ClassCastException exception )
      {
        throw new MailDaemonException( "Send mailbox " + name() 
                                       + " Received a non-Deny message." );
      }
    return true;
  }

} // end of Outbox class


