/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: Receivebox.java,v 1.23 1997/05/08 02:54:24 adam Exp $
 */

package info.net;

/**
 * Receivebox receives Messages from a MailDaemon and files them away
 * in a queue.  Messages can be recovered using the receive method.
 * If there are no Messages in the queue, receive blocks until there
 * are.  There are other methods that allow greater control over the
 * Receivebox, such as an empty method that checks whether the queue
 * is currently empty, and a waitForMessage method that waits for
 * a Message to arrive in the queue, with optional abilities to set
 * finite times. <P> 
 * 
 * In addition, two other variables are associated each
 * Message: the local time stamp (which allows for complete ordering
 * of all Messages received locally by time of arrival), and the
 * return address (which is the address of the mailbox that sent the
 * message).  Use the time and from methods, which act on the oldest
 * message in the queue, to access these two variables. <P>
 *
 * If you remove the Message from the queue, you lose the time and
 * return address of the Message. <P>
 *
 * <PRE>Methods inherited from Inbox:
 *
 * void    waitForMessage () - waits for message to arrive.
 * Message receive ()     - pulls the first message from the queue,
 *                          may suspend on read
 * int     time ()        - returns time stamp of first message on queue
 * boolean nonEmpty ()    - tells if the queue has any messages in it
 * boolean empty ()       - tells if the queue has any messages in it
 * String  name ()        - returns the name of the receivebox
 * Place   from ()        - return the origin of first message on queue.
 * </PRE>
 *
 * <em>Note:
 *
 * <p> Currently the Inbox and the Receivebox are the same; the Inbox
 * is meant as a base class all of the types of Inboxes, so use
 * Receivebox in your application instead.</em>
 *
 * @author Adam Rifkin
 * @author Luke Weisman
 * @version 1.0b2 $Date: 1997/05/08 02:54:24 $
 * @see Broadcastbox
 * @see Filter
 * @see Inbox
 * @see MailDaemon
 * @see MailDaemonException
 * @see Mailbox
 * @see Message
 * @see Multicastbox
 * @see Outbox
 * @see Sendbox
 **/

public class Receivebox extends Inbox
{ 
  // no instance variables


  // constructors

  /**
   * Constructs a new receive Mailbox with a given name, and a
   * reference to the associated MailDaemon. <P>
   *
   * WARNING: Names of the form __x where x is some number are
   * reserved. Do not use them.
   *
   * @param mailDaemon is the MailDaemon associated with this Mailbox.
   * @param mailboxName is the desired Mailbox name.
   * @exception MailDaemonException is thrown if mailboxName
   *                                is already used by mailDaemon.
   **/

  public Receivebox (MailDaemon mailDaemon, String mailboxName) 
    throws MailDaemonException
  {
    super (mailDaemon, mailboxName);
  }


  /**
   * Constructs a new receive Mailbox with a computer-generated name.
   *
   * @param mailDaemon is the MailDaemon associated with this Mailbox.
   **/

  public Receivebox (MailDaemon mailDaemon)
  {
    super (mailDaemon); 
  }


  /**
   * Constructs a new receive Mailbox with a given name, and a
   * reference to the associated MailDaemon. <P>
   *
   * WARNING: Names of the form __x where x is some number are
   * reserved. Do not use them.
   *
   * @param mailDaemon is the MailDaemon associated with this Mailbox.
   * @param mailboxName is the desired Mailbox name.
   * @param filter is the Filter for this Mailbox.
   * @exception MailDaemonException is thrown if mailboxName
   *                                is already used by mailDaemon.
   **/

  public Receivebox (MailDaemon mailDaemon, String mailboxName, Filter filter)
    throws MailDaemonException
  {
    super (mailDaemon, mailboxName);
    setFilter (filter);
  }


  /**
   * Constructs a new receive Mailbox with a computer-generated name
   * and a filter.
   *
   * @param mailDaemon is the MailDaemon associated with this Mailbox.
   * @param filter is the Filter for this Mailbox.
   **/

  public Receivebox (MailDaemon mailDaemon, Filter filter)
  {
    super (mailDaemon);
    setFilter (filter);
  }

} // end of Receivebox class
