/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 *  StringMessage
 */

package info.net;


import java.util.*;
import java.net.*;
import java.io.*;

/* class         StringMessage

   methods:
      byte[] writeData();                     // required by Message class
      void readData(byte [], int index);   // required by message class
*/
/**
 * The StringMessage class is a wrapper for any String which allows for
 * the sending of simple text messages across the net through the mailboxs.<P>
 * The message is written via character reading and writing methods, so no
 * data is lost, even for uuencoded thingies.
 * @see String
 */

public class StringMessage extends Message 
{

  /**
   * The data of the message, which is (surprise surprise) a String.
   */
  String themessage;

  /**
   * This constructor is required by the message class.
   */
  public StringMessage() {themessage = "";}

  /**
   *  Make a StringMessage from a given string.
   *  This allows for such things as:
   *  <pre>
   *      mySendbox.send( new StringMessage( "Hello, dead planet." ) );
   *  </pre>
   *  Which gives a clean way to send Strings with minimal fuss.
   */
  public StringMessage( String text ) 
  {
    themessage = text; 
  }
  
  /**
   * @return The String in the message.
   */
  public String data() { return themessage; }

  /**
   * Set the data of the string to the new passed string.
   * @param d The new data to put into the message.
   */
  public void setData( String d ) { themessage = d.intern(); }


  /**
   * This is the implementation of the abstract function of the Message
   * class. It turns the string into an array of bytes via writeChars
   * method.  It heads this with the length of the String in chars so the
   * read is short and to the point.
   * @see Message
   * @param dos The stream which data gets written into (via the writeChars
   *            method.)
   * @exception IOException If the dos fails for some reason.
   */
  public void writeData( DataOutputStream dos )
    throws IOException
  {
    dos.writeInt( themessage.length() );

    dos.writeChars( themessage );
  }

  /**
   * This is the implementation of the abstract function of the Message
   * class.  It takes a DataInputStream and turns it into a String via the:
   * <pre>
   *       readChar()
   * </pre> method.  It gets the length of the message by reading in the 
   * leading integer cleverly put there.  Note that this allows String
   * messages to be members of other more complex messages, without fear
   * of data after the StringMessage being swallowed.
   * @see Message
   * @param dis The stream to pull the data from to make the StringMessage.
   * @exception InvalidMessageException If the incoming data is invalid
   *            for some reason, this exception is raised.
   * @exception IOException If the dis fails for some reason.
   */
  public void readData( DataInputStream dis )
    throws InvalidMessageException, IOException
  {
    int i, size = dis.readInt();
    StringBuffer sb = new StringBuffer( size );

    if ( dis.available() < size )
      throw new IOException( "Unexpected end of file given size of string." );

    for ( i = 0; i < size; i++ )
      sb.append( dis.readChar() );

    themessage = new String( sb );
  }

  /**
   * @return The String in the message.
   */
  public String toString( )
  {
    return themessage;
  }

} // end StringMessage class

