/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: SyncInbox.java,v 1.11 1997/05/02 22:15:56 adam Exp $
 */


package info.net;


// Needs cleaning up.  -- Adam

/**
 * This mailbox sends acknowledgement messages to the sender when any
 * message is pulled from the queue via the receive() method.  The 
 * sending mailbox should therefore be a SyncSendbox so it can deal
 * with this acknowledgement.<P>
 *
 * testreceive6 and testsend6 illustrate the use of the Sync mailboxs.
 * The acknowledgements sent are DenyMessage( DenyMessage.ACK ) messages.
 *
 * @author Adam Rifkin
 * @author Luke Weisman
 * @version 1.0b2 $Revision: 1.11 $ $Date: 1997/05/02 22:15:56 $
 * @see DenyMessage
 * @see SyncSendbox
 */

public class SyncInbox extends Inbox 
{

  /**
   * The MailDaemon to use to send replys.
   */
  MailDaemon md;

  /**
   * Make a mailbox with given name.
   * @exception MailDaemonException if the name is already used by the maildaemon.
   */
  public SyncInbox( MailDaemon the_md, String name )
    throws MailDaemonException
  {
    super( the_md, name );
    md = the_md;
  }

  /**
   * Make a mailbox with a randomly chosen name.
   */
  public SyncInbox( MailDaemon the_md )
  {
    super( the_md );
    md = the_md;
  }


  /**
   * Receive the message and then
   * send an acknowledgement to the sender of the message being
   * pulled.
   */
  public Message receive( )
  {
    MessageType m;

    //wait for a message to arrive, no matter what.
    silentWaitForMessage();

    // pull off the front of the queue
    m = incoming.GetAndKillFirst();

    SyncMessage msg = (SyncMessage)m.msg;
    
    md.send( new SyncMessage( new DenyMessage( DenyMessage.ACK ),
                              msg.getID() ),
             m.from, this );

    return msg.getMessage();
  }

} // end of SyncInbox.class
