/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: URLClassFileLoader.java,v 1.15 1997/05/29 07:07:33 kiniry Exp $
 *
 * disclaimer: This class loader is based off the NetworkClassLoader
 * supplied as an example by the Sun Class documentation under
 * ClassLoader.
*/

package info.net;

import info.util.Debug;
import java.io.*;
import java.util.*;
import java.net.*;

/**
 * The URLClassFileLoader allows classes to be loaded over the network.
 *
 * @author Adam Rifkin
 * @author Luke Weisman
 * @version 1.0b2 $Date: 1997/05/29 07:07:33 $
 **/

public class URLClassFileLoader 
{

  // instance variables

  private String the_url = new String ();


  // constructors

  /**
   * Construct a new URLClassFileLoader for the given URL.
   * @param url The URL to use.
   */
  public URLClassFileLoader( String url )
  {
    if ( url == null )
      {
        Debug.lpln( 9, "Warning: URLClassFileLoader constructed with" +
                    "null URL.");
        url = new String();
      }

    if ( url.endsWith( "/" ) )
      the_url = url.intern();
    else
      the_url = url + '/';
  }


  // methods

  /**
   * Read a block of bytes from a DataInputStream.
   * @param dis The DataInputStream from which to read the bytes.
   * @return The block of bytes.
   * @exception IOException If there is a problem reading from the stream.
   */

  private byte [] grabBlock (DataInputStream dis)
    throws IOException
  {
    Vector v = new Vector();
    Vector sizes = new Vector();
    int res, tot_size = 0, i, j, lim;
    byte [] block, bigblock;

    res = 0;
    while ( res != -1 )
      {
        block = new byte[ 1024 ];

        res = dis.read( block, 0, 1024 );

        if ( res != -1 )
          {
            Debug.lpln( 9, "Got " + res + " bytes." );

            tot_size += res;
            v.addElement( block );
            sizes.addElement( new Integer( res ) );
          }
        else
          Debug.lpln( 9, "End of file." );
      }

    Debug.lpln( 9, "Total bytes = " + tot_size );
    bigblock = new byte[ tot_size ];

    tot_size = 0;
    for ( i = 0; i < v.size(); i++ )
      {
        block = (byte []) v.elementAt (i);
        lim = ( (Integer)sizes.elementAt( i ) ).intValue();
        
        for ( j = 0; j < lim; j++ )
          bigblock[ tot_size++ ] = block[ j ];
      }

    Debug.lpln(9, "Copied " + tot_size + " bytes in " + 
               v.size() + " chunks." );

    return bigblock;
  } 

  /**
   * Load the class data for a given class.
   * @param name The name of the class to load.
   * @param usi The URLSecurity object to use.
   * @exception ClassNotFoundException if the class cannot be loaded.
   * @exception ClassFormatError if there is something wrong with the loaded
   * class data.
   * @exception SecurityException if there is a security violation.
   */
  public byte [] loadClassData (String name, 
                                URLSecurity usi) 
    throws ClassNotFoundException, ClassFormatError, SecurityException
  {
    String line;
    int i, size, upto, res;
    URL url = null;
    byte [] block;

    try 
      {
        Debug.lpln( 9, "Attempting to load " + name );
        
        String url_string = the_url + name.replace('.','/') + ".class";
        
        //check the url for security reasons.
        if ( !usi.checkURL( url_string ) )
          throw new SecurityException("URL of class forbidden by security.");
        else
          url = new URL( url_string );
        
        Debug.lpln( 9, "Trying to load "+name+" from <" + url + ">" );
        
        url.openConnection();
        DataInputStream dis = new DataInputStream( url.openStream() );
        block = grabBlock( dis );
        Debug.lpln(9, "Got class data successfully, closing stream...");
        dis.close();
        return block;
      }
    catch ( MalformedURLException e )      
      {
        Debug.lpln( 9, "Error: " + e );
        throw new ClassNotFoundException( e.toString() );
      }
    catch ( IOException e )      
      {
        Debug.lpln( 9, "Error(2): " + e );
        throw new ClassNotFoundException( e.toString() );
      }
  }

} // end of URLClassFileLoader class
