/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 *  $Id: URLSecurity.java,v 1.6 1997/05/02 22:16:01 adam Exp $
 */

package info.net;

/**
 * This is the interface for the security which you can attach to the 
 * class loader for the Message classes.  It is used to check URLs in
 * their string form to see if they are acceptable for pulling class
 * data which may be run locally.
 *
 * <P> When a message arrives with a name which is not recognized, the
 * URL that also came with that message is examined.  If it is trusted, the 
 * class data is loaded from that site, and the remote class loader makes
 * an instance of the mystery class.  This class can then be used by the
 * local code when it grabs it via the receive method.  Clearly, a 
 * good security manager is a must, in this case.
 *
 * @author Adam Rifkin
 * @author Luke Weisman
 * @version 1.0b2 $Revision: 1.6 $ $Date: 1997/05/02 22:16:01 $
 **/

public interface URLSecurity 
{
  
  /**
   * Return true if the passed url is trusted enough to download and 
   * execute classes from it.
   **/

  public boolean checkURL( String url );

} // end of URLSecurity interface




