/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: UnknownMessageException.java,v 1.9 1997/04/08 22:17:17 kiniry Exp $
 */

package info.net;

/**
 * UnknownMessageException is thrown when a MailDaemon does not
 * recognize a packet that arrives on its port.  This occurs when
 * either a non-Message-derived packet arrives from an alien source,
 * or when a Message class child is not recognized by the program that
 * throws the exception.
 *
 * @author Adam Rifkin
 * @version 1.0b2 $Date: 1997/04/08 22:17:17 $
 * @see MailDaemonException
 * @see Message
 **/

public class UnknownMessageException extends MailDaemonException
{
  /**
   * instance variable
   *
   * messageName         - the name of the unknown Message.
   **/

  String messageName;


  // constructor

  /**
   * Constructs a new UnknownMessageException with the name
   * of the message that was unknown.
   *
   * @param messageName is the name of the unknown message.
   **/

  public UnknownMessageException (String messageName)
  {
    super ("Unknown Message class >" + messageName + "< arrived.");
    this.messageName = messageName.intern();
  }


  // method

  /**
   * Returns the name of the unknown message.
   **/

  public String getName ()
  {
    return messageName;
  }

} // end of UnknownMessageException class
