/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: Date.java,v 1.7 1997/05/07 22:46:51 dmz Exp $ 
 */

package info.util;

/**
 * A bugfix class for java.util.Date (v1.0.2) - allows you to do what
 * java.util.Date <I>says</I> it allows you to do, while avoiding
 * java.util.Date's normalization bugs.
 *
 * Note that this class does <B>not</B> support the setting of
 * negative time values (at least, not in this version). Attempts to
 * set negative time values will result in the Date remaining
 * unchanged. In addition, attempting to set a year out of the range
 * 1970-2037 will leave the year unchanged.
 *
 * This class is a transparent replacement for java.util.Date in JDK 1.0.2
 * - it has exactly the same methods and interface. Note that if you use
 * this class with JDK 1.1 or higher, you will likely get deprecated API 
 * warnings.
 *
 * @author Daniel M. Zimmerman
 * @version 1.0b2 $Date: 1997/05/07 22:46:51 $
 * @see java.util.Date 
 **/

public class Date extends java.util.Date
{

  // no instance variables

  public Date() 
  { 
    super();
  }
  
  public Date(long date) 
  { 
    super(date); 
  }
  
  public Date(int year, int month, int date)
  {
    super(year, month, date);
  }
  
  public Date(int year, int month, int date, int hours, int min)
  {
    super(year, month, date, hours, min);
  }
  
  public Date(int year, int month, int date, int hours, int min, int sec)
  {
    super(year, month, date, hours, min, sec);
  }
  
  public Date(String s)
  {
    super(s);
  }
  

  // methods (overriding java.util.Date)

  public void setYear(int year)
  {
    if ((year < 70) || (year > 127)) return;
    
    super.setYear(year);
    if (!leapYear(year) && (getMonth() == 2) && (getDate() == 29))
      {
        setDate(1);
        setMonth(3);
      }
  }
  
  public void setMonth(int month)
  {
    if (month < 0) return;
    
    if (month > 11)
      setYear(getYear() + (month/12));
    
    super.setMonth(month%12);
  }
  
  public void setDate(int date)
  {
    if (date < 0) return;
    
    int m = 0;
    while (date > daysInMonth((getMonth()+m)%12,
                              getYear()+((getMonth()+m)/12)))
      date = date - daysInMonth((getMonth()+m)%12, 
                                getYear()+((getMonth()+(m++))/12));
    setMonth(getMonth()+m);
    super.setDate(date);
  }
  
  public void setHours(int hours)
  {
    if (hours < 0) return;
    
    if (hours > 23)
      setDate(getDate() + (hours/24));
    
    super.setHours(hours%24);
  }
  
  public void setMinutes(int minutes)
  {
    if (minutes < 0) return;
    
    if (minutes > 59)
      setHours(getHours() + (minutes/60));
    
    super.setMinutes(minutes%60);
  }
  
  public void setSeconds(int seconds)
  {
    if (seconds < 0) return;
    
    if (seconds > 59)
      setMinutes(getMinutes() + (seconds/60));
    
    super.setSeconds(seconds%60);
  }

  // utility (private) functions

  private boolean leapYear(int year)
  {
    return (((year%4 == 0) && (year%100 != 0)) || (year%400 == 0));
  }
  
  private int daysInMonth(int month, int year)
  {
    int result;
    switch (month)
      {
      case 8:           // 30 days has September,
      case 3:           // April,
      case 5:           // June,
      case 10:          // and November
        result = 30; 
        break;
        
      case 0:           // All the rest have 31
      case 2:
      case 4:
      case 6:
      case 7:
      case 9:
      case 11: 
        result = 31; 
        break;
        
      case 1:           // Except February
        if (leapYear(year))
          result = 29;
        else
          result = 28;
        break;
        
      default: 
        result = 0;
      }
    
    return result;
  }
  
} // end of Date class


