/*
 * The Infospheres Infrastructure
 * Copyright (c) 1996,1997 California Institute of Technology.
 * All Rights Reserved.
 */

/*
 * $Id: Set.java,v 1.9 1997/05/07 22:46:55 dmz Exp $
 */

package info.util;

import java.util.*;

/**
 * The Set allows for a collection of objects, no two of which are
 * equivelant with regards to the equal method of those objects.  This
 * means of course that any object in the set needs to have an equal
 * method defined for it, if the set is to be of any use.
 *
 * @author Joseph R. Kiniry
 * @author Luke Weisman
 * @version 1.0b2 $Date: 1997/05/07 22:46:55 $
 **/

public class Set
{

  /**
   * instance variables
   *
   * vector - The Vector containing the elements of the Set.
   **/

  Vector vector;


  // constructors
  
  /**
   * Constructs a new Set
   **/

  public Set ()
  {
    vector = new Vector ();
  }
  

  // methods

  /**
   * Adds a Object to the set.
   *
   * @param rp The new Object to add to the set. 
   * @return true if the rp was not already in the set, false otherwise.
   **/

  public boolean add (Object rp)
  {
    if ((rp != null) && !vector.contains (rp))
      {
        vector.addElement (rp);
        return true;
      }
    else
      return false;
  }

  
  /**
   * Remove the given Object from the set.
   * @param rp The Object to remove from the set.
   * @return true if the rp was in the set.  False otherwise.
   **/

  public boolean remove (Object rp)
  {
    return vector.removeElement (rp);
  }


  /**
   * @param rp The Object to check for in the current set.
   * @return True if the given rp was in the set, false otherwise.
   **/

  public boolean has (Object rp)
  {
    return vector.contains (rp);
  }

  
  /**
   * Returns an Enumeration containing all the elements in the Set.
   *
   * @return the Enumeration.
   **/

  public Enumeration set ()
  {
    return vector.elements ();
  }
  
  
  /**
   * @return the number of elements in the set.
   **/

  public int size ()
  {
    return vector.size ();
  }
  
} // end of Set class

