////////////////////////////////////////////////////////////
//  DataDriverDevice.h - definition of CDataDriverDevice
//  Portions Copyright (c) 1996-97, BlueWater Systems,Inc
////////////////////////////////////////////////////////////

    // the increment applied to completed requests
#define DATADRIVERDEVICE_IO_INCREMENT   IO_NO_INCREMENT


#ifndef _WDK4XEXT_H_
    // must be included to use any NT 4.0 specific classes
#include <WDK4xExt.h>
#endif

    // the class definition
class CDataDriverDevice : public CDevice
{
public:
        // constructor for CDataDriverDevice device object
    CDataDriverDevice(      PDRIVER_OBJECT    pDriverObject,
                      CONST PWCHAR            pDeviceName,
                      CONST ULONG             DeviceType,
                            PUNICODE_STRING   pRegistryPath,
                      CONST ULONG             DeviceNumber,
                            PDEVICE_OBJECT    *ppDeviceObject,
                            PVOID             pContext);

        // destructor
    ~CDataDriverDevice();

        // driver wide dispatch routines
    friend NTSTATUS CALLBACK DataDriverDeviceCloseDispatch(
        PDEVICE_OBJECT pDeviceObject,
        PIRP           pIrp);
                
    friend NTSTATUS CALLBACK DataDriverDeviceReadDispatch(
        PDEVICE_OBJECT pDeviceObject,
        PIRP           pIrp);

    friend NTSTATUS CALLBACK DataDriverDeviceIoctlDispatch(
        PDEVICE_OBJECT pDeviceObject, 
        PIRP           pIrp);

        // StartIo routine that all queued requests pass through
    friend VOID CALLBACK DataDriverDeviceStartIo(
        PDEVICE_OBJECT  pDeviceObject,
        PIRP            pIrp);

        // Perform the IoctlSetupDevice request from StartIo
    NTSTATUS DataDriverDeviceIoctlSetupDevice(
        PIRP                pIrp,
        PIO_STACK_LOCATION  pIrpStack);

        // Perform the IoctlStartDevice request from StartIo
    NTSTATUS DataDriverDeviceIoctlStartDevice(
        PIRP                pIrp,
        PIO_STACK_LOCATION  pIrpStack);

        // Perform the IoctlStopDevice request from StartIo
    NTSTATUS DataDriverDeviceIoctlStopDevice(
        PIRP                pIrp,
        PIO_STACK_LOCATION  pIrpStack);

protected:
    friend VOID TimerCallback(PKDPC pDpc,PVOID pContext,PVOID SystemArgument1,PVOID SystemArgument2);
    void TimerCallback(PIRP pIrp,PVOID SystemArgument1,PVOID SystemArgument2);

private:
    CRepetitiveTimer    m_Timer;
	BOOLEAN             m_fConfigured;
    BOOLEAN             m_fIsSampling;
    BOOLEAN             m_fIsSquareWave;
	int				    m_IsrCounter;
	int				    m_Frequency;
	LONG			    m_MissedSamples;
    PUSHORT             m_DataBuffer;
    LONG                m_MaxSamples;
    LONG                m_CurrentSample;
    char                m_ChannelMap[BUFFER_ENTRIES + 1];        
};
