/////////////////////////////////////////////////////////////////
//  ioctlrw.cpp - user interface functions
//  Portions Copyright (c) 1996-97, BlueWater Systems,Inc.
/////////////////////////////////////////////////////////////////

    // main WinDK header file
#include "WinDK.h"
    // user interface and ioctl codes
#include "DD_CtlCode.h"
    // driver defines and class definition
#include "DataDriverDevice.h"

extern VOID TimerCallback(PKDPC pDpc,PVOID pContext,
    PVOID SystemArgument1, 
    PVOID SystemArgument2);

///////////////////////////////////////////////////////////////////
//  DataDriverDeviceIoctlIoctlSetupDevice - performs request from StartIo
//  Input:  pIrp - IRP request
//          pIrpStack - IRP stack
//  Output: none
//  Notes:  supports METHOD_BUFFERED ioctls only
///////////////////////////////////////////////////////////////////
NTSTATUS CDataDriverDevice::DataDriverDeviceIoctlSetupDevice(PIRP                pIrp,
                                                             PIO_STACK_LOCATION  pIrpStack)
{
    if (m_fConfigured == TRUE)
    {
        return(STATUS_DEVICE_CONFIGURATION_ERROR);
    }
    if (pIrpStack->Parameters.DeviceIoControl.InputBufferLength < sizeof(DEVICE_CONFIGURATION) ||
        pIrp->AssociatedIrp.SystemBuffer == NULL)
    {
        return(STATUS_INVALID_PARAMETER);
    }
    DEVICE_CONFIGURATION dc = *reinterpret_cast<DEVICE_CONFIGURATION *>(pIrp->AssociatedIrp.SystemBuffer);
    
    if (dc.freq <= 0 || dc.freq > 1024)
    {
        KdPrint(("Frequency is out of range: %d\n",dc.freq));
        dc.freq = 1;
    }
    m_Frequency = dc.freq;
    RtlCopyMemory(m_ChannelMap,dc.channelMap,sizeof(dc.channelMap));
    m_Timer.SetCallback(::TimerCallback,this);            
    m_fConfigured = TRUE;
    return(STATUS_SUCCESS);    
}

///////////////////////////////////////////////////////////////////
//  DataDriverDeviceIoctlIoctlStartDevice - performs request from StartIo
//  Input:  pIrp - IRP request
//          pIrpStack - IRP stack
//  Output: none
//  Notes:  supports METHOD_BUFFERED ioctls only
///////////////////////////////////////////////////////////////////
NTSTATUS CDataDriverDevice::DataDriverDeviceIoctlStartDevice(PIRP                pIrp,
                                                             PIO_STACK_LOCATION  pIrpStack)
{
    if (m_fIsSampling == TRUE)
    {
        return(STATUS_DEVICE_BUSY);
    }
    if (m_fConfigured == FALSE)
    {
        return(STATUS_DEVICE_CONFIGURATION_ERROR);
    }    
    m_MissedSamples = 0;
    m_CurrentSample = 0;
    m_fIsSampling   = TRUE;    
    m_IsrCounter    = m_Frequency;
    KdPrint(("DataDriver: Start timer, frequency = %d(%dms)\n",m_Frequency,static_cast<ULONG>(1000 / m_Frequency)));
    m_Timer.SetRepetitiveTimer(static_cast<ULONG>(1000 / m_Frequency));
    return(STATUS_SUCCESS);
}

///////////////////////////////////////////////////////////////////
//  DataDriverDeviceIoctlIoctlStopDevice - performs request from StartIo
//  Input:  pIrp - IRP request
//          pIrpStack - IRP stack
//  Output: none
//  Notes:  supports METHOD_BUFFERED ioctls only
///////////////////////////////////////////////////////////////////
NTSTATUS CDataDriverDevice::DataDriverDeviceIoctlStopDevice(PIRP                pIrp,
                                                            PIO_STACK_LOCATION  pIrpStack)
{
    if (m_fConfigured == FALSE)
    {
        return(STATUS_DEVICE_CONFIGURATION_ERROR);
    }
    m_Timer.CancelTimer();
    m_fIsSampling = FALSE;
    if (m_MissedSamples)
	{
        KdPrint(("DataDriver: Missed samples = %d\n",m_MissedSamples));
    }                        
    return(STATUS_SUCCESS);    
}

