/////////////////////////////////////////////////////////////////
//  drventry.cpp - DataDrv driver entry point
//  Portions Copyright (c) 1996-97, BlueWater Systems,Inc.
/////////////////////////////////////////////////////////////////

    // main WinDK header file
#include "WinDK.h"
    // user interface and ioctl codes
#include "DD_CtlCode.h"
    // driver defines and class definition
#include "DataDriverDevice.h"

    // This definition controls how many adapters are supported
#define MAX_DATADRV_DEVICE          1

    // routines which can be discarded after initialization
#ifdef ALLOC_PRAGMA
#pragma alloc_text(INIT,DriverEntry)
#endif

///////////////////////////////////////////////////////////////////
//  DriverEntry - initial driver entry point for DataDrv driver
//  Input:  pDriverObject - NT driver object
//          pRegistryPath - path to this drivers registry entries
//  Output: return() - NTSTATUS value
//  Notes:
///////////////////////////////////////////////////////////////////
NTSTATUS CALLBACK DriverEntry(PDRIVER_OBJECT   pDriverObject,
                              PUNICODE_STRING  pRegistryPath)
{
    NTSTATUS            status = STATUS_SUCCESS;    // return status
    CDriver             *pTheDriver = NULL;         // the only driver
    CString             deviceName;                 // the name of the current device
    PDEVICE_OBJECT      pDeviceObject;              // current NT device object
    ULONG               deviceNumber;               // current device number
    CDataDriverDevice   *pDataDriverDevice;         // the current DataDriverDevice device

    KdPrint(("Starting DataDriver. Build with WinDK\n"));
    
        // create the temporary driver class
    pTheDriver = new CDriver(pDriverObject);
    if (pTheDriver == NULL)
    {
        // fatal error, no memory
        KdPrint(("DataDriver: Couldn't create CDriver\n"));
        return STATUS_NO_MEMORY;
    }
        // setup the callback functions
    pTheDriver->SetCallback((PDRIVER_STARTIO) DataDriverDeviceStartIo);
    pTheDriver->SetCallback(IRP_MJ_READ, 
                    (PDRIVER_DISPATCH) DataDriverDeviceReadDispatch);
    pTheDriver->SetCallback(IRP_MJ_DEVICE_CONTROL, 
                    (PDRIVER_DISPATCH) DataDriverDeviceIoctlDispatch);
    pTheDriver->SetCallback(IRP_MJ_CLOSE,
                    (PDRIVER_DISPATCH) DataDriverDeviceCloseDispatch);
        // create a device for each card in the system
    for (deviceNumber = 0; 
         deviceNumber < MAX_DATADRV_DEVICE;
         deviceNumber++) {
            // null out our device pointer
        pDataDriverDevice = NULL;
            // create the device name
        deviceName = Concatenate(L"DataDriverDevice", deviceNumber);
            // create the device object - this will call the 
            // CDataDriverDevice constructor
        status = CreateDevice(pDriverObject, 
                    deviceName, 
                    DATADRIVERDEVICE_DEVICE_TYPE, 
                    pRegistryPath, 
                    deviceNumber, 
                    &pDataDriverDevice, 
                    &pDeviceObject);                                            
        if (!NT_SUCCESS(status))
        {       
                // failed to create the device, cleanup
            KdPrint(("DataDriver: Failed to CreateDevice DataDriverDevice number %d, status(0x%X)\n", 
                     deviceNumber, status));
            if (pDataDriverDevice != NULL)
            {
                delete pDataDriverDevice;
            }
                // do not try to create any more devices
            break;
        }
    }

    if (deviceNumber != 0) {
            // if we found at least one device, then return success
        status = STATUS_SUCCESS;
    } else {
            // failed to create a device, cleanup
        KdPrint(("DataDriver: Failed to create any devices\n"));
        status = STATUS_INSUFFICIENT_RESOURCES;
    }

        // cleanup the CDriver object
    delete pTheDriver;

    return status;
}

///////////////////////////////////////////////////////////////////
//  DataDriverDeviceCloseDispatch - Called when the user/system 
//                                  closes the handle to the device
//  Input:  pDeviceObject - NT device object
//          pIrp - IRP being dispatched
//  Output: return - NT status value
//  Notes:  handles only IRP_MJ_CLOSE
///////////////////////////////////////////////////////////////////
NTSTATUS CALLBACK DataDriverDeviceCloseDispatch(PDEVICE_OBJECT pDeviceObject,
                                                PIRP           pIrp)
{    
    CDataDriverDevice   *pDevice;       // our device object

    // get our device class object
    pDevice = GetDeviceFromDeviceObject(CDataDriverDevice, pDeviceObject);
    if (pDevice->m_fIsSampling == TRUE)
    {
        pDevice->m_Timer.CancelTimer();
        pDevice->m_fIsSampling = FALSE;
    }
	pDevice->m_fConfigured = FALSE;
    pDevice->CompleteIrp(pIrp,STATUS_SUCCESS);
    return(STATUS_SUCCESS);
    
}    

///////////////////////////////////////////////////////////////////
//  DataDriverDeviceReadDispatch - Read file dispatch entry point
//  Input:  pDeviceObject - NT device object
//          pIrp - IRP being dispatched
//  Output: return - NT status value
//  Notes:  handles only IRP_MJ_READ
///////////////////////////////////////////////////////////////////
NTSTATUS CALLBACK DataDriverDeviceReadDispatch(PDEVICE_OBJECT pDeviceObject,
                                               PIRP           pIrp)
{
    CDataDriverDevice   *pDevice;       // our device object
    PIO_STACK_LOCATION  pIrpStack;      // our portion of the irp

        // get our device class object
    pDevice = GetDeviceFromDeviceObject(CDataDriverDevice, pDeviceObject);
        // Initialize the irp info field
    pIrp->IoStatus.Information = 0;
        // Get our portion of the irp
    pIrpStack = IoGetCurrentIrpStackLocation(pIrp);
            
    NTSTATUS status = STATUS_SUCCESS;
                      
    if (pIrp->AssociatedIrp.SystemBuffer == NULL)
    {
        status = STATUS_INVALID_PARAMETER;        
    }
    if (pIrpStack->Parameters.Read.Length < sizeof(DATA_BUFFER))
    {
        status = STATUS_BUFFER_TOO_SMALL;        
    }
    if (status == STATUS_SUCCESS)
    {
        pDevice->QueueIrp(pIrp,WinDKIrpCancelCallback);
        return STATUS_PENDING;            
    }
    else
    {
        pDevice->CompleteIrp(pIrp, status);
        return status;        
    }        
}

///////////////////////////////////////////////////////////////////
//  DataDriverDeviceIoctlDispatch - Device I/O control dispatch entry point
//  Input:  pDeviceObject - NT device object
//          pIrp - IRP being dispatched
//  Output: return - NT status value
//  Notes:  handles only IRP_MJ_DEVICE_CONTROL
///////////////////////////////////////////////////////////////////
NTSTATUS CALLBACK DataDriverDeviceIoctlDispatch(PDEVICE_OBJECT pDeviceObject,
                                                PIRP           pIrp)
{
    CDataDriverDevice   *pDevice;       // our device object
    PIO_STACK_LOCATION  pIrpStack;      // our portion of the irp
    NTSTATUS            status = STATUS_NOT_IMPLEMENTED; // return status

        // get our device class object
    pDevice = GetDeviceFromDeviceObject(CDataDriverDevice, pDeviceObject);
        // Initialize the irp info field
    pIrp->IoStatus.Information = 0;
        // Get our portion of the irp
    pIrpStack = IoGetCurrentIrpStackLocation(pIrp);
        
    switch (pIrpStack->Parameters.DeviceIoControl.IoControlCode)
    {
        case IOCTL_DATADRIVER_SETUP:
            status = pDevice->DataDriverDeviceIoctlSetupDevice(pIrp, pIrpStack);
            break;
        case IOCTL_DATADRIVER_START:
            status = pDevice->DataDriverDeviceIoctlStartDevice(pIrp, pIrpStack);
            break;
        case IOCTL_DATADRIVER_STOP:
            status = pDevice->DataDriverDeviceIoctlStopDevice(pIrp, pIrpStack);
            break;            
    }
    pDevice->CompleteIrp(pIrp,status);
    return status;
}

///////////////////////////////////////////////////////////////////
//  DataDriverDeviceStartIo - DataDriverDevice StartIo entry point
//  Input:  pDeviceObject - NT device object
//          pIrp - IRP from queue
//  Output: return - NT status value
//  Notes:  handles all queued requests
///////////////////////////////////////////////////////////////////
VOID CALLBACK DataDriverDeviceStartIo(PDEVICE_OBJECT pDeviceObject,
                                      PIRP           pIrp)
{
    // All the work is done in the timer callback!
}
