#define VDW_MAIN
#include <vdw.h>
#pragma hdrstop
#include "DataDriver.h"
// Include files for device classes
#include "DataDriverDevice.h"

#pragma code_seg("INIT")

DECLARE_DRIVER_CLASS(DataDriver,NULL)

// Driver Entry routine
//		This routine is called when the driver is loaded.
//		Usually, this is where any devices associated with
//		the driver are created.
//
//		The driver often reads the registry at DriverEntry in
//		order to setup various configurable parameters.
//
//		Driver::Works makes it easy to use the registry to also
//		control what devices are present and should be created.
//
NTSTATUS DataDriver :: DriverEntry(PUNICODE_STRING RegistryPath)
{
	DbgPrint("Starting DataDriver. Build with Driver::Works\n");
	// cfgStatus is used to track the result of the device creation requests
	// made by the configuration callbacks made during the registry scan.
	CONFIGSTATUS cfgStatus;
	cfgStatus.status = STATUS_SUCCESS;

    // Scan registry and create an instance of DataDriverDevice for each unit found
    KConfigurationQuery QueryCombi2Device(LinkTo(DataDriverDeviceConfigCallback),
	                                            &cfgStatus,
											    L"DataDriverDevice");
	if (!NT_SUCCESS(cfgStatus.status))
	{
	    // cfgStatus.unit holds unit number of device that failed to build
		DeleteDevices();
		return cfgStatus.status;
	}
	// If no errors returned during device construction, return success code.
	return STATUS_SUCCESS;
}

#pragma code_seg()
    
//  The DataDriverConfigCallback routine is called once for each
//  DataDriverDevice unit that is found during the registry scan.
//	The callback should create a device object for each unit.
//
NTSTATUS DataDriver :: DataDriverDeviceConfigCallback(ULONG unit,PVOID pConfigStatus)
{
	NTSTATUS status = STATUS_SUCCESS;
	PCONFIGSTATUS pStat = reinterpret_cast<PCONFIGSTATUS>(pConfigStatus);	

	// If previous callback failed, abort this run.
	if (!NT_SUCCESS(pStat->status))
	{
		return STATUS_REQUEST_ABORTED;		
	}		
	// Create a device object for this unit.
    DataDriverDevice *pDataDriverDevice;
	
    pDataDriverDevice = new (NonPagedPool) DataDriverDevice(unit);
    if (pDataDriverDevice == NULL)
	{
		// Failed to create new device.
        DbgPrint("Error creating device DataDriverDevice unit %d\n",unit);
		pStat->unit     = unit;
    	pStat->status   = STATUS_INSUFFICIENT_RESOURCES;
    	status          = STATUS_REQUEST_ABORTED;
	}
	else if (!NT_SUCCESS(pDataDriverDevice->ConstructorStatus()))
	{
	    // Error returned from constructor
    	pStat->unit     = unit;
        pStat->status   = pDataDriverDevice->ConstructorStatus();     
        delete pDataDriverDevice;
    	status =  STATUS_REQUEST_ABORTED;
	}
	return status;
}