#ifndef __DataDriverDevice_h__
#define __DataDriverDevice_h__

#if !defined(DD_CtlCode_h)
	#include "DD_CtlCode.h"
#endif	

class DataDriverDevice : public KDevice
{										
	SAFE_DESTRUCTORS
public:
	// Member Functions
    DataDriverDevice(ULONG unit = 0);	
    ~DataDriverDevice();
	    
    DEVMEMBER_CANCELIRP(DataDriverDevice,Cancel);
   	MEMBER_DPC(DataDriverDevice,TimerCallback);
	DEVMEMBER_DISPATCHERS
#if 0
    The following member functions are actually defined by the
    DEVMEMBER_DISPATCHERS macro.  These comment-only definitions
    allow easy navigation to the functions within the Developer Studio.
    ;	
    COMMENT_ONLY Cancel(KIrp irp);
    COMMENT_ONLY CleanUp(KIrp irp);
    COMMENT_ONLY Close(KIrp irp);
    COMMENT_ONLY Create(KIrp irp);
    COMMENT_ONLY DeviceControl(KIrp irp);
    COMMENT_ONLY StartIo(KIrp irp);
	COMMENT_ONLY Read(KIrp irp);                
#endif

private:
	KTimedCallback  m_Timer;	
	BOOLEAN         m_fConfigured;
    BOOLEAN         m_fIsSampling;
    BOOLEAN         m_fIsSquareWave;
	LONG     		m_IsrCounter;
	LONG			m_Frequency;
	LONG			m_MissedSamples;
    PUSHORT         m_DataBuffer;
    LONG            m_MaxSamples;
    LONG            m_CurrentSample;
    CHAR            m_ChannelMap[BUFFER_ENTRIES + 1];    
};

#endif    // __DataDriverDevice_h__
