// Getting, claming and using resources
// with WinDK.

// Get the resources from the registry
CRegistry *pRegistry = new CRegistry(m_DriverRegPath);

pRegistry->SetRelativePath(Concatenate(pDeviceName,L"\\Parameters"));
pRegistry->GetKey(L"PortBase",&m_PortBase);
pRegistry->GetKey(L"PortRange",&m_PortRange);
pRegistry->GetKey(L"Irq",&m_Irq);
delete pRegistry;

BOOLEAN fConflict;

CResource *pResources = new CResource(ISA,0,this,2);

pResources->AddPortResource(m_MappedAddress);
pResources->AddInterruptResource(m_Interrupt);
pResources->AssignCardsResources(
    m_DriverRegPath,
    &conflict
    );
delete pResources;

// Accessing the IO-ports using WinDK
WINDK_MAPPED_ADDRESS m_MappedAddress

// map the device ports
m_MappedAddress.Length                      = m_PortRange;
m_MappedAddress.PortType                    = PORT_MAPPED;
m_MappedAddress.UnmappedAddress.LowPart     = m_PortBase;
m_MappedAddress.UnmappedAddress.HighPart    = 0;
m_MappedAddress.Flags                       = CmResourceShareDeviceExclusive;

// map the I/O address
status = MapIoAddress(Isa, busNumber, m_MappedAddress);

// Write to port
WRITE_PORT_UCHAR((PUCHAR)(m_MappedAddress.pAddress));

// Map an interrupt
WINDK_INTERRUPT_RESOURCE m_Interrupt;

// Setup an interrupt with WinDK
m_Interrupt.Level       = m_Irq;
m_Interrupt.Vector      = m_Irq;
m_Interrupt.Affinity    = 0;
m_Interrupt.Flags       = CmResourceShareDeviceExclusive;
m_Interrupt.Mode        = Latched;

// DpcForIsr and Isr is static functions they can however
// use member functions
InitializeInterrupt(
    ISA,
    0,
    reinterpret_cast<PIO_DPC_ROUTINE>(DpcForIsr),
    reinterpret_cast<PIO_DPC_ROUTINE>(Isr),
    this,
    m_Interrupt    
    );// Claming resources with WinDK

// The resources are automatically released in the destructor

// Unmap the I/O address
UnmapIoAddress(m_MappedAddress);